/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class Cached<K, V>
implements Function<K, V> {
    private final Function<K, V> mappingFunction;
    private final Map<K, V> cache = new ConcurrentHashMap();

    Cached(Function<K, V> mappingFunction) {
        this.mappingFunction = mappingFunction;
    }

    public static <K, V> Function<K, V> of(Function<K, V> mappingFunction) {
        return new Cached<K, V>(mappingFunction);
    }

    @Override
    public V apply(K key) {
        return this.cache.computeIfAbsent(key, this.mappingFunction);
    }
}

