/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.util.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.finmath.util.config.nodes.ConfigNode;
import net.finmath.util.config.nodes.Node;
import net.finmath.util.config.nodes.SpecialNodes;
import net.finmath.util.config.nodes.ValueNode;

public class ConfigTree {
    private final Node root;

    public ConfigTree(List<String> keyOrder, List<Map<String, Object>> configs) {
        this.root = this.group(keyOrder, configs);
    }

    public Object getConfig(Map<String, Object> selector) {
        Node node = this.root;
        while (node instanceof ConfigNode) {
            ConfigNode configNode = (ConfigNode)node;
            if (selector.containsKey(configNode.getKey()) && configNode.getValueToConfig().keySet().contains(selector.get(configNode.getKey()))) {
                node = configNode.getValueToConfig().get(selector.get(configNode.getKey()));
                continue;
            }
            node = configNode.getValueToConfig().get((Object)SpecialNodes.DEFAULT_VALUE);
            if (!Objects.isNull(node)) continue;
            throw new IllegalArgumentException("Neither a value nor a default branch exists in the config tree for " + configNode.getKey() + " at the current location. " + selector);
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            return valueNode.getValue();
        }
        throw new IllegalArgumentException("Unable to resolve configuration from the given properties. " + selector);
    }

    private Node group(List<String> keyOrder, List<Map<String, Object>> configs) {
        if (keyOrder.size() > 0) {
            String key = keyOrder.get(0);
            Map<Object, List<Map>> grouped = configs.stream().collect(Collectors.groupingBy(map -> map.get(key)));
            List<String> keyOrderRemain = keyOrder.subList(1, keyOrder.size());
            Map<Object, Node> valueToConfig = grouped.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.group(keyOrderRemain, (List)entry.getValue())));
            return new ConfigNode(key, valueToConfig);
        }
        if (configs.size() == 1) {
            Map<String, Object> config = configs.get(0);
            Object value = config.get("value");
            return new ValueNode(value);
        }
        throw new IllegalArgumentException("Multiple configs for the same selector values. " + Arrays.deepToString(configs.toArray()));
    }
}

