/*
 * Decompiled with CFR 0.152.
 */
package net.folivo.trixnity.crypto.key;

import io.ktor.util.Base64Kt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.folivo.trixnity.core.model.events.m.secretstorage.SecretKeyEventContent;
import net.folivo.trixnity.crypto.core.AesHmacSha2Kt;
import net.folivo.trixnity.crypto.core.Base58Kt;
import net.folivo.trixnity.crypto.core.Pbkdf2Sha512Kt;
import net.folivo.trixnity.crypto.key.RecoveryKeyInvalidException;
import net.folivo.trixnity.crypto.key.RecoveryKeyUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u001a\u001e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\r\u001a$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0013\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"recoveryKeyPrefix", "", "", "encodeRecoveryKey", "", "recoveryKey", "", "decodeRecoveryKey", "encodedRecoveryKey", "recoveryKeyFromPassphrase", "passphrase", "info", "Lnet/folivo/trixnity/core/model/events/m/secretstorage/SecretKeyEventContent$AesHmacSha2Key$SecretStorageKeyPassphrase;", "(Ljava/lang/String;Lnet/folivo/trixnity/core/model/events/m/secretstorage/SecretKeyEventContent$AesHmacSha2Key$SecretStorageKeyPassphrase;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkRecoveryKey", "Lkotlin/Result;", "", "key", "Lnet/folivo/trixnity/core/model/events/m/secretstorage/SecretKeyEventContent$AesHmacSha2Key;", "([BLnet/folivo/trixnity/core/model/events/m/secretstorage/SecretKeyEventContent$AesHmacSha2Key;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "trixnity-crypto"})
@SourceDebugExtension(value={"SMAP\nRecoveryKeyUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecoveryKeyUtils.kt\nnet/folivo/trixnity/crypto/key/RecoveryKeyUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,59:1\n1803#2,3:60\n1878#2,3:74\n488#3,11:63\n12897#4,3:77\n*S KotlinDebug\n*F\n+ 1 RecoveryKeyUtils.kt\nnet/folivo/trixnity/crypto/key/RecoveryKeyUtilsKt\n*L\n15#1:60,3\n21#1:74,3\n20#1:63,11\n25#1:77,3\n*E\n"})
public final class RecoveryKeyUtilsKt {
    @NotNull
    private static final List<Byte> recoveryKeyPrefix;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String encodeRecoveryKey(@NotNull byte[] recoveryKey) {
        void $this$fold$iv;
        void initial$iv;
        Intrinsics.checkNotNullParameter((Object)recoveryKey, (String)"recoveryKey");
        List recoveryKeyWithPrefix = CollectionsKt.plus((Collection)recoveryKeyPrefix, (Iterable)ArraysKt.toList((byte[])recoveryKey));
        Iterable iterable = recoveryKeyWithPrefix;
        boolean bl = false;
        Collection collection = recoveryKeyWithPrefix;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void byteVal;
            byte by = ((Number)element$iv).byteValue();
            void parity = accumulator$iv;
            boolean bl2 = false;
            accumulator$iv = parity ^ byteVal;
        }
        void var12_12 = accumulator$iv;
        return CollectionsKt.joinToString$default((Iterable)StringsKt.chunked((CharSequence)Base58Kt.encodeBase58((byte[])CollectionsKt.toByteArray((Collection)CollectionsKt.plus((Collection)collection, (Object)((byte)var12_12)))), (int)4), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] decodeRecoveryKey(@NotNull String encodedRecoveryKey) {
        void $this$fold$iv;
        int index;
        char element$iv$iv;
        void $this$filterNotTo$iv$iv;
        int n;
        Intrinsics.checkNotNullParameter((Object)encodedRecoveryKey, (String)"encodedRecoveryKey");
        String $this$filterNot$iv = encodedRecoveryKey;
        boolean $i$f$filterNot = false;
        CharSequence charSequence = $this$filterNot$iv;
        Object destination$iv$iv = new StringBuilder();
        boolean $i$f$filterNotTo = false;
        for (n = 0; n < $this$filterNotTo$iv$iv.length(); ++n) {
            char it = element$iv$iv = $this$filterNotTo$iv$iv.charAt(n);
            boolean bl = false;
            if (CharsKt.isWhitespace((char)it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        byte[] recoveryKey = Base58Kt.decodeBase58((String)((StringBuilder)destination$iv$iv).toString());
        Object $this$forEachIndexed$iv = recoveryKeyPrefix;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        destination$iv$iv = $this$forEachIndexed$iv.iterator();
        while (destination$iv$iv.hasNext()) {
            void prefix;
            Object item$iv = destination$iv$iv.next();
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            element$iv$iv = (char)((Number)item$iv).byteValue();
            index = n;
            boolean bl = false;
            Byte by = ArraysKt.getOrNull((byte[])recoveryKey, (int)index);
            if (by != null ? by.byteValue() == prefix : false) continue;
            throw new RecoveryKeyInvalidException("wrong prefix");
        }
        $this$forEachIndexed$iv = recoveryKey;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (void element$iv : $this$fold$iv) {
            void byteVal;
            index = element$iv;
            int parity = accumulator$iv;
            boolean bl = false;
            accumulator$iv = parity ^ byteVal;
        }
        if (accumulator$iv != 0) {
            throw new RecoveryKeyInvalidException("wrong parity");
        }
        int recoveryKeyLength = 32;
        if (recoveryKey.length != recoveryKeyLength + recoveryKeyPrefix.size() + 1) {
            throw new RecoveryKeyInvalidException("wrong recovery key length");
        }
        return ArraysKt.copyOfRange((byte[])recoveryKey, (int)recoveryKeyPrefix.size(), (int)(recoveryKey.length - 1));
    }

    @Nullable
    public static final Object recoveryKeyFromPassphrase(@NotNull String passphrase, @NotNull SecretKeyEventContent.AesHmacSha2Key.SecretStorageKeyPassphrase info, @NotNull Continuation<? super byte[]> $completion) {
        SecretKeyEventContent.AesHmacSha2Key.SecretStorageKeyPassphrase secretStorageKeyPassphrase = info;
        if (secretStorageKeyPassphrase instanceof SecretKeyEventContent.AesHmacSha2Key.SecretStorageKeyPassphrase.Pbkdf2) {
            Integer n = ((SecretKeyEventContent.AesHmacSha2Key.SecretStorageKeyPassphrase.Pbkdf2)info).getBits();
            return Pbkdf2Sha512Kt.generatePbkdf2Sha512((String)passphrase, (byte[])StringsKt.encodeToByteArray((String)((SecretKeyEventContent.AesHmacSha2Key.SecretStorageKeyPassphrase.Pbkdf2)info).getSalt()), (int)((SecretKeyEventContent.AesHmacSha2Key.SecretStorageKeyPassphrase.Pbkdf2)info).getIterations(), (int)(n != null ? n : 256), $completion);
        }
        if (secretStorageKeyPassphrase instanceof SecretKeyEventContent.AesHmacSha2Key.SecretStorageKeyPassphrase.Unknown) {
            throw new IllegalArgumentException("unknown algorithm not supported");
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object checkRecoveryKey(@NotNull byte[] var0, @NotNull SecretKeyEventContent.AesHmacSha2Key var1_1, @NotNull Continuation<? super Result<Unit>> $completion) {
        if (!($completion instanceof checkRecoveryKey.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    Object object = RecoveryKeyUtilsKt.checkRecoveryKey(null, null, (Continuation<? super Result<Unit>>)((Continuation)this));
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Result.box-impl((Object)object);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = info.getIv();
                if (v0 == null) ** GOTO lbl17
                v1 = Base64Kt.decodeBase64Bytes((String)v0);
                v0 = v1;
                if (v1 != null) ** GOTO lbl18
lbl17:
                // 2 sources

                throw new IllegalArgumentException("iv was null");
lbl18:
                // 1 sources

                $continuation.L$0 = info;
                $continuation.label = 1;
                v2 = AesHmacSha2Kt.createAesHmacSha2MacFromKey((byte[])key, (byte[])v0, (Continuation)$continuation);
                if (v2 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl28
            }
            case 1: {
                info = (SecretKeyEventContent.AesHmacSha2Key)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl28:
                // 2 sources

                mac = (String)v2;
                return !Intrinsics.areEqual((Object)info.getMac(), (Object)mac) ? Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new RecoveryKeyInvalidException("expected mac " + mac + ", but got " + info.getMac()))) : Result.constructor-impl((Object)Unit.INSTANCE);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static {
        Object[] objectArray = new Byte[]{(byte)-117, (byte)1};
        recoveryKeyPrefix = CollectionsKt.listOf((Object[])objectArray);
    }
}

