/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.aoc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import net.fornwall.aoc.Solver;

class JarNativeLibraryLoader {
    JarNativeLibraryLoader() {
    }

    static void loadLibraryFromJar(String baseName) {
        try {
            String libraryName = JarNativeLibraryLoader.determineLibraryName(baseName);
            File tmpFile = Files.createTempFile("java-jni-" + baseName, null, new FileAttribute[0]).toFile();
            tmpFile.deleteOnExit();
            InputStream in = Solver.class.getResourceAsStream("/" + libraryName);
            if (in == null) {
                throw new RuntimeException("No library named " + libraryName);
            }
            try (InputStream inputStream = in;){
                Files.copy(in, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            System.load(tmpFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String determineLibraryName(String baseName) {
        String archExtension;
        boolean isX86_64;
        String suffix;
        String prefix;
        String osName = System.getProperty("os.name", "unknown").toLowerCase(Locale.ENGLISH);
        boolean isLinux = osName.contains("linux");
        boolean isMac = osName.contains("darwin") || osName.contains("os x") || osName.contains("osx");
        boolean isWindows = osName.contains("windows");
        if (isLinux) {
            prefix = "lib";
            suffix = ".so";
        } else if (isMac) {
            prefix = "lib";
            suffix = ".dylib";
        } else if (isWindows) {
            prefix = "";
            suffix = ".dll";
        } else {
            throw new RuntimeException("Unsupported operating system (os.name): " + osName);
        }
        String arch = System.getProperty("os.arch", "unknown").toLowerCase(Locale.ENGLISH);
        boolean isArm64 = arch.equals("arm-v8") || arch.equals("arm64") || arch.equals("aarch64");
        boolean bl = isX86_64 = arch.equals("x86-64") || arch.equals("x86_64") || arch.equals("amd64") || arch.equals("x64");
        if (isX86_64) {
            archExtension = "_x86_64";
        } else if (isArm64) {
            archExtension = "_aarch64";
        } else {
            throw new RuntimeException("Unsupported CPU (os.arch): " + osName);
        }
        return prefix + baseName + archExtension + suffix;
    }
}

