/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.ElfSection;
import net.fornwall.jelf.ElfSectionHeader;
import net.fornwall.jelf.ElfSymbol;
import net.fornwall.jelf.ElfSymbolTableSection;

public class ElfHashTable
extends ElfSection {
    private final int[] buckets;
    private final int[] chain;

    ElfHashTable(ElfParser parser, ElfSectionHeader header) {
        super(parser, header);
        int i;
        parser.seek(header.sh_offset);
        int num_buckets = parser.readInt();
        int num_chains = parser.readInt();
        this.buckets = new int[num_buckets];
        for (i = 0; i < num_buckets; ++i) {
            this.buckets[i] = parser.readInt();
        }
        this.chain = new int[num_chains];
        for (i = 0; i < num_chains; ++i) {
            this.chain[i] = parser.readInt();
        }
        int actual = num_buckets * 4 + num_chains * 4 + 8;
        if (header.sh_size != (long)actual) {
            throw new ElfException("Error reading string table (read " + actual + "bytes, expected to read " + header.sh_size + "bytes).");
        }
    }

    public ElfSymbol lookupSymbol(String name, ElfSymbolTableSection symbolTable) {
        long hashValue = ElfHashTable.elfHash(name);
        int index = this.buckets[(int)(hashValue % (long)this.buckets.length)];
        while (index != 0) {
            ElfSymbol symbol = symbolTable.symbols[index];
            if (name.equals(symbol.getName())) {
                return symbol;
            }
            index = this.chain[index];
        }
        return null;
    }

    static long elfHash(String name) {
        long hash = 0L;
        int nameLength = name.length();
        for (int i = 0; i < nameLength; ++i) {
            long x = (hash = (hash << 4) + (long)name.charAt(i)) & 0xF0000000L;
            if (x != 0L) {
                hash ^= x >> 24;
            }
            hash &= x ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return hash;
    }
}

