/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import net.fornwall.jelf.BackingFile;
import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfFile;
import net.fornwall.jelf.ElfSegment;

class ElfParser {
    final ElfFile elfFile;
    private final BackingFile backingFile;

    ElfParser(ElfFile elfFile, BackingFile backingFile) {
        this.elfFile = elfFile;
        this.backingFile = backingFile;
    }

    public void seek(long offset) {
        this.backingFile.seek(offset);
    }

    public void skip(int bytesToSkip) {
        this.backingFile.skip(bytesToSkip);
    }

    short readUnsignedByte() {
        return this.backingFile.readUnsignedByte();
    }

    short readShort() throws ElfException {
        short ch1 = this.readUnsignedByte();
        short ch2 = this.readUnsignedByte();
        if (this.elfFile.ei_data == 1) {
            return (short)(((short)ch2 & 0xFF) << 8 | (short)ch1 & 0xFF);
        }
        return (short)(((short)ch1 & 0xFF) << 8 | (short)ch2 & 0xFF);
    }

    int readInt() throws ElfException {
        short ch1 = this.readUnsignedByte();
        short ch2 = this.readUnsignedByte();
        short ch3 = this.readUnsignedByte();
        short ch4 = this.readUnsignedByte();
        if (this.elfFile.ei_data == 1) {
            return (ch4 & 0xFF) << 24 | (ch3 & 0xFF) << 16 | (ch2 & 0xFF) << 8 | ch1 & 0xFF;
        }
        return (ch1 & 0xFF) << 24 | (ch2 & 0xFF) << 16 | (ch3 & 0xFF) << 8 | ch4 & 0xFF;
    }

    long readLong() {
        short ch1 = this.readUnsignedByte();
        short ch2 = this.readUnsignedByte();
        short ch3 = this.readUnsignedByte();
        short ch4 = this.readUnsignedByte();
        short ch5 = this.readUnsignedByte();
        short ch6 = this.readUnsignedByte();
        short ch7 = this.readUnsignedByte();
        short ch8 = this.readUnsignedByte();
        if (this.elfFile.ei_data == 1) {
            return (long)ch8 << 56 | ((long)ch7 & 0xFFL) << 48 | ((long)ch6 & 0xFFL) << 40 | ((long)ch5 & 0xFFL) << 32 | ((long)ch4 & 0xFFL) << 24 | ((long)ch3 & 0xFFL) << 16 | ((long)ch2 & 0xFFL) << 8 | (long)ch1 & 0xFFL;
        }
        return (long)ch1 << 56 | ((long)ch2 & 0xFFL) << 48 | ((long)ch3 & 0xFFL) << 40 | ((long)ch4 & 0xFFL) << 32 | ((long)ch5 & 0xFFL) << 24 | ((long)ch6 & 0xFFL) << 16 | ((long)ch7 & 0xFFL) << 8 | (long)ch8 & 0xFFL;
    }

    long readIntOrLong() {
        return this.elfFile.ei_class == 1 ? (long)this.readInt() : this.readLong();
    }

    long unsignedByte(int arg) {
        long val = arg >= 0 ? (long)arg : this.unsignedByte((short)(arg >>> 16)) << 16 | (long)((short)arg);
        return val;
    }

    long virtualMemoryAddrToFileOffset(long address) {
        for (int i = 0; i < this.elfFile.e_phnum; ++i) {
            ElfSegment ph = this.elfFile.getProgramHeader(i);
            if (address < ph.p_vaddr || address >= ph.p_vaddr + ph.p_memsz) continue;
            long relativeOffset = address - ph.p_vaddr;
            if (relativeOffset >= ph.p_filesz) {
                throw new ElfException("Can not convert virtual memory address " + Long.toHexString(address) + " to file offset - found segment " + String.valueOf(ph) + " but address maps to memory outside file range");
            }
            return ph.p_offset + relativeOffset;
        }
        throw new ElfException("Cannot find segment for address " + Long.toHexString(address));
    }

    public int read(byte[] data) {
        return this.backingFile.read(data);
    }
}

