/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import net.fornwall.jelf.ElfFile;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.ElfSymbol;

public final class ElfRelocation {
    public final long r_offset;
    public final long r_info;
    private final ElfFile elfFile;

    ElfRelocation(ElfParser parser, long offset) {
        parser.seek(offset);
        this.r_offset = parser.readIntOrLong();
        this.r_info = parser.readIntOrLong();
        this.elfFile = parser.elfFile;
    }

    public long getType() {
        return this.elfFile.is32Bits() ? this.r_info & 0xFFL : (long)((int)this.r_info);
    }

    public int getSymbolIndex() {
        return (int)(this.r_info >> (this.elfFile.is32Bits() ? 8 : 32));
    }

    public ElfSymbol getSymbol() {
        return this.elfFile.getSymbolTableSection().symbols[this.getSymbolIndex()];
    }
}

