/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.ElfSectionHeader;

public class ElfSection {
    public final ElfSectionHeader header;
    protected final ElfParser parser;

    ElfSection(ElfParser parser, ElfSectionHeader header) {
        this.header = header;
        this.parser = parser;
    }

    public byte[] getData() {
        if (this.header.sh_size == 0L || this.header.sh_type == 8 || this.header.sh_type == 0) {
            return new byte[0];
        }
        if (this.header.sh_size > Integer.MAX_VALUE) {
            throw new ElfException("Too big section: " + this.header.sh_size);
        }
        byte[] result = new byte[(int)this.header.sh_size];
        this.parser.seek(this.header.sh_offset);
        this.parser.read(result);
        return result;
    }
}

