/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.MemoizedObject;

public class ElfSegment {
    public static final int PT_NULL = 0;
    public static final int PT_LOAD = 1;
    public static final int PT_DYNAMIC = 2;
    public static final int PT_INTERP = 3;
    public static final int PT_NOTE = 4;
    public static final int PT_SHLIB = 5;
    public static final int PT_PHDR = 6;
    public static final int PT_TLS = 7;
    public static final int PT_LOOS = 0x60000000;
    public static final int PT_HIOS = 0x6FFFFFFF;
    public static final int PT_LOPROC = 0x70000000;
    public static final int PT_HIPROC = Integer.MAX_VALUE;
    public final int p_type;
    public final int p_flags;
    public final long p_offset;
    public final long p_vaddr;
    public final long p_paddr;
    public final long p_filesz;
    public final long p_memsz;
    public final long p_align;
    private MemoizedObject<String> ptInterpreter;

    ElfSegment(final ElfParser parser, long offset) {
        parser.seek(offset);
        if (parser.elfFile.ei_class == 1) {
            this.p_type = parser.readInt();
            this.p_offset = parser.readInt();
            this.p_vaddr = parser.readInt();
            this.p_paddr = parser.readInt();
            this.p_filesz = parser.readInt();
            this.p_memsz = parser.readInt();
            this.p_flags = parser.readInt();
            this.p_align = parser.readInt();
        } else {
            this.p_type = parser.readInt();
            this.p_flags = parser.readInt();
            this.p_offset = parser.readLong();
            this.p_vaddr = parser.readLong();
            this.p_paddr = parser.readLong();
            this.p_filesz = parser.readLong();
            this.p_memsz = parser.readLong();
            this.p_align = parser.readLong();
        }
        switch (this.p_type) {
            case 3: {
                this.ptInterpreter = new MemoizedObject<String>(){

                    @Override
                    protected String computeValue() throws ElfException {
                        short b;
                        parser.seek(ElfSegment.this.p_offset);
                        StringBuilder buffer = new StringBuilder();
                        while ((b = parser.readUnsignedByte()) != 0) {
                            buffer.append((char)b);
                        }
                        return buffer.toString();
                    }
                };
            }
        }
    }

    public String toString() {
        Object typeString = switch (this.p_type) {
            case 0 -> "PT_NULL";
            case 1 -> "PT_LOAD";
            case 2 -> "PT_DYNAMIC";
            case 3 -> "PT_INTERP";
            case 4 -> "PT_NOTE";
            case 5 -> "PT_SHLIB";
            case 6 -> "PT_PHDR";
            default -> "0x" + Long.toHexString(this.p_type);
        };
        Object pFlagsString = "";
        if (this.isReadable()) {
            pFlagsString = (String)pFlagsString + (((String)pFlagsString).isEmpty() ? "" : "|") + "read";
        }
        if (this.isWriteable()) {
            pFlagsString = (String)pFlagsString + (((String)pFlagsString).isEmpty() ? "" : "|") + "write";
        }
        if (this.isExecutable()) {
            pFlagsString = (String)pFlagsString + (((String)pFlagsString).isEmpty() ? "" : "|") + "execute";
        }
        if (((String)pFlagsString).isEmpty()) {
            pFlagsString = "0x" + Long.toHexString(this.p_flags);
        }
        return "ElfProgramHeader[p_type=" + (String)typeString + ", p_filesz=" + this.p_filesz + ", p_memsz=" + this.p_memsz + ", p_flags=" + (String)pFlagsString + ", p_align=" + this.p_align + ", range=[0x" + Long.toHexString(this.p_vaddr) + "-0x" + Long.toHexString(this.p_vaddr + this.p_memsz) + "]]";
    }

    public String getIntepreter() {
        return this.ptInterpreter == null ? null : this.ptInterpreter.getValue();
    }

    public boolean isReadable() {
        return (this.p_flags & 4) != 0;
    }

    public boolean isWriteable() {
        return (this.p_flags & 2) != 0;
    }

    public boolean isExecutable() {
        return (this.p_flags & 1) != 0;
    }
}

