/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfFile;
import net.fornwall.jelf.ElfParser;

public final class ElfSymbol {
    public static final int BINDING_LOCAL = 0;
    public static final int BINDING_GLOBAL = 1;
    public static final int BINDING_WEAK = 2;
    public static final int BINDING_LOPROC = 13;
    public static final int BINDING_HIPROC = 15;
    public static final byte STT_NOTYPE = 0;
    public static final byte STT_OBJECT = 1;
    public static final byte STT_FUNC = 2;
    public static final byte STT_SECTION = 3;
    public static final byte STT_FILE = 4;
    public static final byte STT_COMMON = 5;
    public static final byte STT_TLS = 6;
    public static final byte STT_LOOS = 10;
    public static final byte STT_HIOS = 12;
    public static final byte STT_LOPROC = 13;
    public static final byte STT_HIPROC = 15;
    public final int st_name;
    public final long st_value;
    public final long st_size;
    public final short st_info;
    public final short st_other;
    public final short st_shndx;
    public final int section_type;
    public final long offset;
    private final ElfFile elfHeader;

    ElfSymbol(ElfParser parser, long offset, int section_type) {
        this.elfHeader = parser.elfFile;
        parser.seek(offset);
        this.offset = offset;
        if (parser.elfFile.ei_class == 1) {
            this.st_name = parser.readInt();
            this.st_value = parser.readInt();
            this.st_size = parser.readInt();
            this.st_info = parser.readUnsignedByte();
            this.st_other = parser.readUnsignedByte();
            this.st_shndx = parser.readShort();
        } else {
            this.st_name = parser.readInt();
            this.st_info = parser.readUnsignedByte();
            this.st_other = parser.readUnsignedByte();
            this.st_shndx = parser.readShort();
            this.st_value = parser.readLong();
            this.st_size = parser.readLong();
        }
        this.section_type = section_type;
        switch (this.getType()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 13: {
                break;
            }
            case 15: {
                break;
            }
        }
    }

    public int getBinding() {
        return this.st_info >> 4;
    }

    public int getType() {
        return this.st_info & 0xF;
    }

    public String getName() throws ElfException {
        if (this.st_name == 0) {
            return null;
        }
        String symbol_name = null;
        if (this.section_type == 2) {
            symbol_name = this.elfHeader.getStringTable().get(this.st_name);
        } else if (this.section_type == 11) {
            symbol_name = this.elfHeader.getDynamicStringTable().get(this.st_name);
        }
        return symbol_name;
    }

    public Visibility getVisibility() {
        if (this.st_other < 0 || this.st_other > 3) {
            throw new ElfException("Unsupported st_other=" + this.st_other);
        }
        return Visibility.values()[this.st_other];
    }

    public String toString() {
        int typeInt = this.getType();
        return "ElfSymbol[name=" + this.getName() + ", type=" + (switch (typeInt) {
            case 0 -> "unspecified";
            case 1 -> "object";
            case 2 -> "function";
            case 3 -> "section";
            case 4 -> "file";
            case 13 -> "loproc";
            case 15 -> "hiproc";
            default -> Integer.toString(typeInt);
        }) + ", size=" + this.st_size + "]";
    }

    static enum Visibility {
        STV_DEFAULT,
        STV_INTERNAL,
        STV_HIDDEN,
        STV_PROTECTED;

    }
}

