/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import net.fornwall.jelf.BackingFile;
import net.fornwall.jelf.ElfException;

public class MappedFile
implements BackingFile {
    private final MappedByteBuffer mappedByteBuffer;

    public MappedFile(MappedByteBuffer mappedByteBuffer) {
        this.mappedByteBuffer = mappedByteBuffer;
        this.mappedByteBuffer.position(0);
    }

    @Override
    public void seek(long offset) {
        this.mappedByteBuffer.position((int)offset);
    }

    @Override
    public void skip(int bytesToSkip) {
        this.mappedByteBuffer.position(this.mappedByteBuffer.position() + bytesToSkip);
    }

    @Override
    public short readUnsignedByte() {
        int val = -1;
        byte temp = this.mappedByteBuffer.get();
        val = temp & 0xFF;
        if (val < 0) {
            throw new ElfException("Trying to read outside file");
        }
        return (short)val;
    }

    @Override
    public int read(byte[] data) {
        this.mappedByteBuffer.get(data);
        return data.length;
    }

    public byte get() {
        return this.mappedByteBuffer.get();
    }

    public int write(byte[] data) {
        this.mappedByteBuffer.put(data);
        return data.length;
    }

    public void put(byte data) {
        this.mappedByteBuffer.put(data);
    }

    public ByteBuffer getBuffer() {
        return this.mappedByteBuffer;
    }
}

