/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import net.fornwall.jelf.BackingFile;
import net.fornwall.jelf.ElfException;

class ByteArrayAsFile
implements BackingFile {
    private final ByteArrayInputStream byteArray;

    public ByteArrayAsFile(byte[] buffer) {
        this(new ByteArrayInputStream(buffer));
    }

    public ByteArrayAsFile(ByteArrayInputStream byteArray) {
        this.byteArray = byteArray;
    }

    @Override
    public void seek(long offset) {
        this.byteArray.reset();
        if (this.byteArray.skip(offset) != offset) {
            throw new ElfException("seeking outside file");
        }
    }

    @Override
    public void skip(int bytesToSkip) {
        long skipped = this.byteArray.skip(bytesToSkip);
        if (skipped != (long)bytesToSkip) {
            throw new IllegalArgumentException("Wanted to skip " + bytesToSkip + " bytes, but only able to skip " + skipped);
        }
    }

    @Override
    public short readUnsignedByte() {
        int val = -1;
        val = this.byteArray.read();
        if (val < 0) {
            throw new ElfException("Trying to read outside file");
        }
        return (short)val;
    }

    @Override
    public int read(byte[] data) {
        try {
            return this.byteArray.read(data);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading " + data.length + " bytes", e);
        }
    }
}

