/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import java.util.ArrayList;
import java.util.List;
import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.ElfSection;
import net.fornwall.jelf.ElfSectionHeader;
import net.fornwall.jelf.ElfStringTable;
import net.fornwall.jelf.MemoizedObject;

public class ElfDynamicSection
extends ElfSection {
    public static final int DT_NULL = 0;
    public static final int DT_NEEDED = 1;
    public static final int DT_PLTRELSZ = 2;
    public static final int DT_PLTGOT = 3;
    public static final int DT_HASH = 4;
    public static final int DT_STRTAB = 5;
    public static final int DT_SYMTAB = 6;
    public static final int DT_RELA = 7;
    public static final int DT_RELASZ = 8;
    public static final int DT_RELAENT = 9;
    public static final int DT_STRSZ = 10;
    public static final int DT_SYMENT = 11;
    public static final int DT_INIT = 12;
    public static final int DT_FINI = 13;
    public static final int DT_SONAME = 14;
    public static final int DT_RPATH = 15;
    public static final int DT_SYMBOLIC = 16;
    public static final int DT_REL = 17;
    public static final int DT_RELSZ = 18;
    public static final int DT_RELENT = 19;
    public static final int DT_PLTREL = 20;
    public static final int DT_DEBUG = 21;
    public static final int DT_TEXTREL = 22;
    public static final int DT_JMPREL = 23;
    public static final int DT_BIND_NOW = 24;
    public static final int DT_INIT_ARRAY = 25;
    public static final int DT_FINI_ARRAY = 26;
    public static final int DT_INIT_ARRAYSZ = 27;
    public static final int DT_FINI_ARRAYSZ = 28;
    public static final int DT_RUNPATH = 29;
    public static final int DT_FLAGS = 30;
    public static final int DT_PREINIT_ARRAY = 32;
    public static final int DT_GNU_HASH = 1879047925;
    public static final int DT_FLAGS_1 = 0x6FFFFFFB;
    public static final int DT_VERDEF = 0x6FFFFFFC;
    public static final int DT_VERDEFNUM = 0x6FFFFFFD;
    public static final int DT_VERNEEDED = 0x6FFFFFFE;
    public static final int DT_VERNEEDNUM = 0x6FFFFFFF;
    public static final int DF_ORIGIN = 1;
    public static final int DF_SYMBOLIC = 2;
    public static final int DF_TEXTREL = 4;
    public static final int DF_BIND_NOW = 8;
    public static final int DF_1_NOW = 1;
    public static final int DF_1_GLOBAL = 2;
    public static final int DF_1_GROUP = 4;
    public static final int DF_1_NODELETE = 8;
    public static final int DF_1_LOADFLTR = 16;
    public static final int DF_1_INITFIRST = 32;
    public static final int DF_1_NOOPEN = 64;
    public static final int DF_1_ORIGIN = 128;
    public static final int DF_1_DIRECT = 256;
    public static final int DF_1_TRANS = 512;
    public static final int DF_1_INTERPOSE = 1024;
    public static final int DF_1_NODEFLIB = 2048;
    public static final int DF_1_NODUMP = 4096;
    public static final int DF_1_CONFALT = 8192;
    public static final int DF_1_ENDFILTEE = 16384;
    public static final int DF_1_DISPRELDNE = 32768;
    public static final int DF_1_DISPRELPND = 65536;
    public static final int DF_1_NODIRECT = 131072;
    public static final int DF_1_IGNMULDEF = 262144;
    public static final int DF_1_NOKSYMS = 524288;
    public static final int DF_1_NOHDR = 0x100000;
    public static final int DF_1_EDITED = 0x200000;
    public static final int DF_1_NORELOC = 0x400000;
    public static final int DF_1_SYMINTPOSE = 0x800000;
    public static final int DF_1_GLOBAUDIT = 0x1000000;
    public static final int DF_1_SINGLETON = 0x2000000;
    public static final int DF_1_STUB = 0x4000000;
    public static final int DF_1_PIE = 0x8000000;
    public long dt_strtab_offset;
    public int dt_strtab_size;
    private MemoizedObject<ElfStringTable> dtStringTable;
    public final List<ElfDynamicStructure> entries = new ArrayList<ElfDynamicStructure>();

    /*
     * Enabled aggressive block sorting
     */
    public ElfDynamicSection(final ElfParser parser, ElfSectionHeader header) {
        super(parser, header);
        parser.seek(header.sh_offset);
        int numEntries = (int)(header.sh_size / 8L);
        int i = 0;
        while (i < numEntries) {
            long d_tag = parser.readIntOrLong();
            final long d_val_or_ptr = parser.readIntOrLong();
            this.entries.add(new ElfDynamicStructure(d_tag, d_val_or_ptr));
            switch ((int)d_tag) {
                case 0: {
                    return;
                }
                case 5: {
                    this.dtStringTable = new MemoizedObject<ElfStringTable>(){

                        @Override
                        protected ElfStringTable computeValue() throws ElfException {
                            long fileOffsetForStringTable = parser.virtualMemoryAddrToFileOffset(d_val_or_ptr);
                            return new ElfStringTable(parser, fileOffsetForStringTable, ElfDynamicSection.this.dt_strtab_size, null);
                        }
                    };
                    this.dt_strtab_offset = d_val_or_ptr;
                    break;
                }
                case 10: {
                    if (d_val_or_ptr > Integer.MAX_VALUE) {
                        throw new ElfException("Too large DT_STRSZ: " + d_val_or_ptr);
                    }
                    this.dt_strtab_size = (int)d_val_or_ptr;
                }
            }
            ++i;
        }
    }

    private ElfDynamicStructure firstEntryWithTag(long desiredTag) {
        for (ElfDynamicStructure entry : this.entries) {
            if (entry.d_tag != desiredTag) continue;
            return entry;
        }
        return null;
    }

    public List<String> getNeededLibraries() throws ElfException {
        ElfStringTable stringTable = this.dtStringTable.getValue();
        ArrayList<String> result = new ArrayList<String>();
        for (ElfDynamicStructure entry : this.entries) {
            if (entry.d_tag != 1L) continue;
            result.add(stringTable.get((int)entry.d_val_or_ptr));
        }
        return result;
    }

    public String getRunPath() {
        ElfDynamicStructure runPathEntry = this.firstEntryWithTag(29L);
        return runPathEntry == null ? null : this.dtStringTable.getValue().get((int)runPathEntry.d_val_or_ptr);
    }

    public long getFlags() {
        ElfDynamicStructure flagsEntry = this.firstEntryWithTag(30L);
        return flagsEntry == null ? 0L : flagsEntry.d_val_or_ptr;
    }

    public long getFlags1() {
        ElfDynamicStructure flagsEntry = this.firstEntryWithTag(0x6FFFFFFBL);
        return flagsEntry == null ? 0L : flagsEntry.d_val_or_ptr;
    }

    public String toString() {
        return "ElfDynamicStructure{entries=" + this.entries + "}";
    }

    public static class ElfDynamicStructure {
        public final long d_tag;
        public final long d_val_or_ptr;

        public ElfDynamicStructure(long d_tag, long d_val_or_ptr) {
            this.d_tag = d_tag;
            this.d_val_or_ptr = d_val_or_ptr;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.d_tag ^ this.d_tag >>> 32);
            result = 31 * result + (int)(this.d_val_or_ptr ^ this.d_val_or_ptr >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ElfDynamicStructure other = (ElfDynamicStructure)obj;
            if (this.d_tag != other.d_tag) {
                return false;
            }
            return this.d_val_or_ptr == other.d_val_or_ptr;
        }

        public String toString() {
            return "ElfDynamicSectionEntry{tag=" + this.d_tag + ", d_val_or_ptr=" + this.d_val_or_ptr + "}";
        }
    }
}

