/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.ElfSection;
import net.fornwall.jelf.ElfSectionHeader;
import net.fornwall.jelf.ElfSymbol;
import net.fornwall.jelf.ElfSymbolTableSection;

public class ElfGnuHashTable
extends ElfSection {
    private final int ELFCLASS_BITS;
    final int symoffset;
    final int bloom_shift;
    final long[] bloom;
    final int[] buckets;
    int[] chain;

    ElfGnuHashTable(ElfParser parser, ElfSectionHeader header) {
        super(parser, header);
        int i;
        this.ELFCLASS_BITS = parser.elfFile.ei_class == 1 ? 32 : 64;
        parser.seek(header.sh_offset);
        int numberOfBuckets = parser.readInt();
        this.symoffset = parser.readInt();
        int bloomSize = parser.readInt();
        this.bloom_shift = parser.readInt();
        this.bloom = new long[bloomSize];
        this.buckets = new int[numberOfBuckets];
        for (i = 0; i < bloomSize; ++i) {
            this.bloom[i] = parser.readIntOrLong();
        }
        for (i = 0; i < numberOfBuckets; ++i) {
            this.buckets[i] = parser.readInt();
        }
    }

    ElfSymbol lookupSymbol(String symbolName, ElfSymbolTableSection symbolTable) {
        long mask;
        int nameHash;
        long word;
        if (this.chain == null) {
            int chainSize = ((ElfSymbolTableSection)this.parser.elfFile.firstSectionByType((int)11)).symbols.length - this.symoffset;
            this.chain = new int[chainSize];
            this.parser.seek(this.header.sh_offset + 16L + (long)(this.bloom.length * (this.ELFCLASS_BITS / 8)) + (long)(this.buckets.length * 4));
            for (int i = 0; i < chainSize; ++i) {
                this.chain[i] = this.parser.readInt();
            }
        }
        if (((word = this.bloom[Integer.remainderUnsigned(Integer.divideUnsigned(nameHash = ElfGnuHashTable.gnuHash(symbolName), this.ELFCLASS_BITS), this.bloom.length)]) & (mask = 1L << (int)((long)Integer.remainderUnsigned(nameHash, this.ELFCLASS_BITS)) | 1L << (int)((long)Integer.remainderUnsigned(nameHash >>> this.bloom_shift, this.ELFCLASS_BITS)))) != mask) {
            return null;
        }
        int symix = this.buckets[Integer.remainderUnsigned(nameHash, this.buckets.length)];
        if (symix < this.symoffset) {
            return null;
        }
        while (true) {
            ElfSymbol symbol;
            int hash;
            if (((long)nameHash | 1L) == ((long)(hash = this.chain[symix - this.symoffset]) | 1L) && symbolName.equals((symbol = symbolTable.symbols[symix]).getName())) {
                return symbol;
            }
            symbol = symbolTable.symbols[symix];
            if ((hash & 1) != 0) break;
            ++symix;
        }
        return null;
    }

    static int gnuHash(String name) {
        int h = 5381;
        int nameLength = name.length();
        for (int i = 0; i < nameLength; ++i) {
            char c = name.charAt(i);
            h = (h << 5) + h + c;
        }
        return h;
    }
}

