/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.ElfSection;
import net.fornwall.jelf.ElfSectionHeader;

public class ElfNoteSection
extends ElfSection {
    public static final int NT_GNU_ABI_TAG = 1;
    public static final int NT_GNU_HWCAP = 2;
    public static final int NT_GNU_BUILD_ID = 3;
    public static final int NT_GNU_GOLD_VERSION = 4;
    public final int n_namesz;
    public final int n_descsz;
    public final int n_type;
    private final String n_name;
    private final byte[] descriptorBytes;
    private final GnuAbiDescriptor gnuAbiDescriptor;

    ElfNoteSection(ElfParser parser, ElfSectionHeader header) throws ElfException {
        super(parser, header);
        parser.seek(header.sh_offset);
        this.n_namesz = parser.readInt();
        this.n_descsz = parser.readInt();
        this.n_type = parser.readInt();
        byte[] nameBytes = new byte[this.n_namesz];
        this.descriptorBytes = new byte[this.n_descsz];
        int bytesRead = parser.read(nameBytes);
        if (bytesRead != this.n_namesz) {
            throw new ElfException("Error reading note name (read=" + bytesRead + ", expected=" + this.n_namesz + ")");
        }
        parser.skip(bytesRead % 4);
        switch (this.n_type) {
            case 1: {
                this.gnuAbiDescriptor = new GnuAbiDescriptor(parser.readInt(), parser.readInt(), parser.readInt(), parser.readInt());
                break;
            }
            default: {
                this.gnuAbiDescriptor = null;
            }
        }
        bytesRead = parser.read(this.descriptorBytes);
        if (bytesRead != this.n_descsz) {
            throw new ElfException("Error reading note name (read=" + bytesRead + ", expected=" + this.n_descsz + ")");
        }
        this.n_name = new String(nameBytes, 0, this.n_namesz - 1);
    }

    public String getName() {
        return this.n_name;
    }

    public byte[] descriptorBytes() {
        return this.descriptorBytes;
    }

    public String descriptorAsString() {
        return new String(this.descriptorBytes);
    }

    public GnuAbiDescriptor descriptorAsGnuAbi() {
        return this.gnuAbiDescriptor;
    }

    public static final class GnuAbiDescriptor {
        public static final int ELF_NOTE_OS_LINUX = 0;
        public static final int ELF_NOTE_OS_GNU = 1;
        public static final int ELF_NOTE_OS_SOLARIS2 = 2;
        public static final int ELF_NOTE_OS_FREEBSD = 3;
        public final int operatingSystem;
        public final int majorVersion;
        public final int minorVersion;
        public final int subminorVersion;

        public GnuAbiDescriptor(int operatingSystem, int majorVersion, int minorVersion, int subminorVersion) {
            this.operatingSystem = operatingSystem;
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
            this.subminorVersion = subminorVersion;
        }
    }
}

