/*
 * Decompiled with CFR 0.152.
 */
package net.fornwall.jelf;

import net.fornwall.jelf.ElfException;
import net.fornwall.jelf.ElfParser;
import net.fornwall.jelf.ElfSection;
import net.fornwall.jelf.ElfSectionHeader;

public final class ElfStringTable
extends ElfSection {
    private final byte[] data;
    public final int numStrings;

    ElfStringTable(ElfParser parser, long offset, int length, ElfSectionHeader header) throws ElfException {
        super(parser, header);
        parser.seek(offset);
        this.data = new byte[length];
        int bytesRead = parser.read(this.data);
        if (bytesRead != length) {
            throw new ElfException("Error reading string table (read " + bytesRead + "bytes - expected to read " + this.data.length + "bytes)");
        }
        int stringsCount = 0;
        for (byte datum : this.data) {
            if (datum != 0) continue;
            ++stringsCount;
        }
        this.numStrings = stringsCount;
    }

    public String get(int index) {
        int endPtr = index;
        while (this.data[endPtr] != 0) {
            ++endPtr;
        }
        return new String(this.data, index, endPtr - index);
    }
}

