/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata;

import net.fortytwo.flow.Sink;
import net.fortytwo.flow.rdf.RDFSink;
import net.fortytwo.ripple.RippleException;
import org.openrdf.model.BNode;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class BNodeToURIFilter
implements RDFSink {
    private final Sink<Statement> stSink;
    private final Sink<Namespace> nsSink;
    private final Sink<String> cmtSink;
    private ValueFactory valueFactory;

    public BNodeToURIFilter(RDFSink sink, ValueFactory vf) {
        this.valueFactory = vf;
        final Sink destStSink = sink.statementSink();
        this.stSink = new Sink<Statement>(){

            public void put(Statement st) throws RippleException {
                boolean c;
                boolean s = st.getSubject() instanceof BNode;
                boolean o = st.getObject() instanceof BNode;
                boolean bl = c = null != st.getContext() && st.getContext() instanceof BNode;
                if (s || o || c) {
                    Resource subj = s ? BNodeToURIFilter.this.bnodeToUri((BNode)st.getSubject()) : st.getSubject();
                    URI pred = st.getPredicate();
                    Value obj = o ? BNodeToURIFilter.this.bnodeToUri((BNode)st.getObject()) : st.getObject();
                    Resource con = c ? BNodeToURIFilter.this.bnodeToUri((BNode)st.getContext()) : st.getContext();
                    Statement newSt = null == con ? BNodeToURIFilter.this.valueFactory.createStatement(subj, pred, obj) : BNodeToURIFilter.this.valueFactory.createStatement(subj, pred, obj, con);
                    destStSink.put((Object)newSt);
                } else {
                    destStSink.put((Object)st);
                }
            }
        };
        this.nsSink = sink.namespaceSink();
        this.cmtSink = sink.commentSink();
    }

    private URI bnodeToUri(BNode bnode) {
        return this.valueFactory.createURI("urn:uuid:" + bnode.getID());
    }

    public Sink<Statement> statementSink() {
        return this.stSink;
    }

    public Sink<Namespace> namespaceSink() {
        return this.nsSink;
    }

    public Sink<String> commentSink() {
        return this.cmtSink;
    }
}

