/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata.dereferencers;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import net.fortytwo.linkeddata.Dereferencer;
import net.fortytwo.ripple.RippleException;
import org.openrdf.rio.RDFFormat;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StreamRepresentation;

public class FileURIDereferencer
implements Dereferencer {
    @Override
    public Representation dereference(String uri) throws RippleException {
        return new FileRepresentation(uri);
    }

    public static MediaType findMediaType(String uri) throws RippleException {
        RDFFormat format = RDFFormat.forFileName((String)uri);
        if (null == format) {
            throw new RippleException("no matching media type for " + uri);
        }
        List types = format.getMIMETypes();
        if (0 == types.size()) {
            throw new IllegalStateException("RDF format has no media type(s): " + format);
        }
        return new MediaType((String)types.iterator().next());
    }

    public String toString() {
        return "file URI dereferencer";
    }

    private class FileRepresentation
    extends StreamRepresentation {
        private InputStream inputStream;

        public FileRepresentation(String uri) throws RippleException {
            super(FileURIDereferencer.findMediaType(uri));
            try {
                this.inputStream = new FileInputStream(uri.substring(5));
            }
            catch (IOException e) {
                throw new RippleException((Throwable)e);
            }
        }

        public ReadableByteChannel getChannel() throws IOException {
            return null;
        }

        public InputStream getStream() throws IOException {
            return this.inputStream;
        }

        public void write(OutputStream outputStream) throws IOException {
        }

        public void write(WritableByteChannel writableByteChannel) throws IOException {
        }
    }
}

