/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata.dereferencers;

import java.util.HashSet;
import java.util.Set;
import net.fortytwo.linkeddata.Dereferencer;
import net.fortytwo.linkeddata.LinkedDataCache;
import net.fortytwo.linkeddata.dereferencers.HTTPRepresentation;
import net.fortytwo.ripple.RippleException;
import net.fortytwo.ripple.StringUtils;
import org.apache.log4j.Logger;
import org.restlet.representation.Representation;

public class HTTPURIDereferencer
implements Dereferencer {
    private static final Logger LOGGER = Logger.getLogger(HTTPURIDereferencer.class);
    private final LinkedDataCache linkedDataCache;
    private final Set<String> badExtensions;

    public HTTPURIDereferencer(LinkedDataCache linkedDataCache) {
        this.linkedDataCache = linkedDataCache;
        this.badExtensions = new HashSet<String>();
    }

    @Override
    public Representation dereference(String uri) throws RippleException {
        int l = uri.lastIndexOf(46);
        if (l >= 0 && this.badExtensions.contains(uri.substring(l + 1))) {
            throw new RippleException("URI <" + StringUtils.escapeURIString((String)uri) + "> has blacklisted extension");
        }
        return new HTTPRepresentation(uri, this.linkedDataCache.getAcceptHeader());
    }

    public void blackListExtension(String ext) {
        this.badExtensions.add(ext);
    }

    public void whitelistExtension(String ext) {
        this.badExtensions.remove(ext);
    }

    public String toString() {
        return "HTTP URI dereferencer";
    }
}

