/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.ripple;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import net.fortytwo.ripple.RippleException;

public class RippleProperties
extends Properties {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public RippleProperties(Properties defaults) {
        super(defaults);
    }

    public RippleProperties() {
    }

    private String getProperty(String name, boolean required) throws RippleException {
        String s = this.getProperty(name);
        if (null == s && required) {
            throw new RippleException("no value for property: " + name);
        }
        return s;
    }

    public String getString(String name) throws RippleException {
        return this.getProperty(name, true);
    }

    public String getString(String name, String defaultValue) throws RippleException {
        String value = this.getProperty(name, false);
        return null == value ? defaultValue : value;
    }

    public void setString(String name, String value) {
        if (null == value) {
            this.remove(name);
        } else {
            this.setProperty(name, value);
        }
    }

    public boolean getBoolean(String name) throws RippleException {
        String value = this.getProperty(name, true);
        return value.equals("true");
    }

    public boolean getBoolean(String name, boolean defaultValue) throws RippleException {
        String value = this.getProperty(name, false);
        return null == value ? defaultValue : value.equals("true");
    }

    public void setBoolean(String name, boolean value) {
        this.setProperty(name, "" + value);
    }

    public double getDouble(String name) throws RippleException {
        String value = this.getProperty(name, true);
        try {
            return new Double(value);
        }
        catch (NumberFormatException e) {
            throw new RippleException(e);
        }
    }

    public double getDouble(String name, double defaultValue) throws RippleException {
        String value = this.getProperty(name, false);
        try {
            return null == value ? defaultValue : new Double(value);
        }
        catch (NumberFormatException e) {
            throw new RippleException(e);
        }
    }

    public void setDouble(String name, double value) {
        this.setProperty(name, "" + value);
    }

    public float getFloat(String name) throws RippleException {
        String value = this.getProperty(name, true);
        try {
            return new Float(value).floatValue();
        }
        catch (NumberFormatException e) {
            throw new RippleException(e);
        }
    }

    public float getFloat(String name, float defaultValue) throws RippleException {
        String value = this.getProperty(name, false);
        try {
            return null == value ? defaultValue : new Float(value).floatValue();
        }
        catch (NumberFormatException e) {
            throw new RippleException(e);
        }
    }

    public void setFloat(String name, float value) {
        this.setProperty(name, "" + value);
    }

    public int getInt(String name) throws RippleException {
        String value = this.getProperty(name, true);
        try {
            return new Integer(value);
        }
        catch (NumberFormatException e) {
            throw new RippleException(e);
        }
    }

    public int getInt(String name, int defaultValue) throws RippleException {
        String value = this.getProperty(name, false);
        try {
            return null == value ? defaultValue : new Integer(value);
        }
        catch (NumberFormatException e) {
            throw new RippleException(e);
        }
    }

    public void setInt(String name, int value) {
        this.setProperty(name, "" + value);
    }

    public long getLong(String name) throws RippleException {
        String value = this.getProperty(name, true);
        try {
            return new Long(value);
        }
        catch (NumberFormatException e) {
            throw new RippleException(e);
        }
    }

    public long getLong(String name, long defaultValue) throws RippleException {
        String value = this.getProperty(name, false);
        try {
            return null == value ? defaultValue : new Long(value);
        }
        catch (NumberFormatException e) {
            throw new RippleException(e);
        }
    }

    public void setLong(String name, long value) {
        this.setProperty(name, "" + value);
    }

    public URI getURI(String name) throws RippleException {
        String value = this.getProperty(name, true);
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            throw new RippleException(e);
        }
    }

    public URI getURI(String name, URI defaultValue) throws RippleException {
        String value = this.getProperty(name, false);
        try {
            return null == value ? defaultValue : new URI(value);
        }
        catch (URISyntaxException e) {
            throw new RippleException(e);
        }
    }

    public void setURI(String name, URI value) {
        if (null == value) {
            this.remove(name);
        } else {
            this.setProperty(name, value.toString());
        }
    }

    public URL getURL(String name) throws RippleException {
        String value = this.getProperty(name, true);
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            throw new RippleException(e);
        }
    }

    public URL getURL(String name, URL defaultValue) throws RippleException {
        String value = this.getProperty(name, false);
        try {
            return null == value ? defaultValue : new URL(value);
        }
        catch (MalformedURLException e) {
            throw new RippleException(e);
        }
    }

    public void setURL(String name, URL value) {
        if (null == value) {
            this.remove(name);
        } else {
            this.setProperty(name, value.toString());
        }
    }

    public File getFile(String name) throws RippleException {
        String value = this.getProperty(name, true);
        return new File(value);
    }

    public File getFile(String name, File defaultValue) throws RippleException {
        String value = this.getProperty(name, false);
        return null == value ? defaultValue : new File(value);
    }

    public void setFile(String name, File value) {
        if (null == value) {
            this.remove(name);
        } else {
            this.setProperty(name, "" + value.getAbsolutePath());
        }
    }

    public Date getDate(String name) throws RippleException {
        String value = this.getProperty(name, true);
        try {
            return this.dateFormat.parse(value);
        }
        catch (ParseException e) {
            throw new RippleException(e);
        }
    }

    public Date getDate(String name, Date defaultValue) throws RippleException {
        String value = this.getProperty(name, false);
        try {
            return null == value ? defaultValue : this.dateFormat.parse(value);
        }
        catch (ParseException e) {
            throw new RippleException(e);
        }
    }

    public void setDate(String name, Date value) {
        if (null == value) {
            this.remove(name);
        } else {
            this.setProperty(name, "" + this.dateFormat.format(value));
        }
    }
}

