/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.flow.rdf.diff;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.fortytwo.flow.Sink;
import net.fortytwo.flow.diff.DiffSink;
import net.fortytwo.flow.rdf.RDFSink;
import net.fortytwo.flow.rdf.diff.RDFDiffCollector;
import net.fortytwo.flow.rdf.diff.RDFDiffSink;
import net.fortytwo.flow.rdf.diff.RDFDiffSource;
import net.fortytwo.ripple.RippleException;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;

public final class RDFDiffContextFilter
implements RDFDiffSink {
    private final Map<Resource, RDFDiffCollector> contextToCollectorMap = new HashMap<Resource, RDFDiffCollector>();
    private final RDFSink addSink;
    private final RDFSink subSink;
    private final DiffSink<Statement> stSink;
    private final DiffSink<Namespace> nsSink;
    private final DiffSink<String> cmtSink;

    public RDFDiffContextFilter() {
        Sink<Statement> stAddSink = new Sink<Statement>(){

            public void put(Statement st) throws RippleException {
                Resource context = st.getContext();
                RDFDiffCollector sink = (RDFDiffCollector)RDFDiffContextFilter.this.contextToCollectorMap.get(context);
                if (null == sink) {
                    sink = new RDFDiffCollector();
                    RDFDiffContextFilter.this.contextToCollectorMap.put(context, sink);
                }
                sink.adderSink().statementSink().put((Object)st);
            }
        };
        Sink<Statement> stSubSink = new Sink<Statement>(){

            public void put(Statement st) throws RippleException {
                Resource context = st.getContext();
                RDFDiffCollector sink = (RDFDiffCollector)RDFDiffContextFilter.this.contextToCollectorMap.get(context);
                if (null == sink) {
                    sink = new RDFDiffCollector();
                    RDFDiffContextFilter.this.contextToCollectorMap.put(context, sink);
                }
                sink.subtractorSink().statementSink().put((Object)st);
            }
        };
        Sink<Namespace> nsAddSink = new Sink<Namespace>(){

            public void put(Namespace ns) throws RippleException {
                ((RDFDiffCollector)RDFDiffContextFilter.this.contextToCollectorMap.get(null)).adderSink().namespaceSink().put((Object)ns);
            }
        };
        Sink<Namespace> nsSubSink = new Sink<Namespace>(){

            public void put(Namespace ns) throws RippleException {
                ((RDFDiffCollector)RDFDiffContextFilter.this.contextToCollectorMap.get(null)).subtractorSink().namespaceSink().put((Object)ns);
            }
        };
        Sink<String> cmtAddSink = new Sink<String>(){

            public void put(String comment) throws RippleException {
                ((RDFDiffCollector)RDFDiffContextFilter.this.contextToCollectorMap.get(null)).adderSink().commentSink().put((Object)comment);
            }
        };
        Sink<String> cmtSubSink = new Sink<String>(){

            public void put(String comment) throws RippleException {
                ((RDFDiffCollector)RDFDiffContextFilter.this.contextToCollectorMap.get(null)).subtractorSink().commentSink().put((Object)comment);
            }
        };
        this.addSink = new RDFSink((Sink)stAddSink, (Sink)nsAddSink, (Sink)cmtAddSink){
            final /* synthetic */ Sink val$stAddSink;
            final /* synthetic */ Sink val$nsAddSink;
            final /* synthetic */ Sink val$cmtAddSink;
            {
                this.val$stAddSink = sink;
                this.val$nsAddSink = sink2;
                this.val$cmtAddSink = sink3;
            }

            @Override
            public Sink<Statement> statementSink() {
                return this.val$stAddSink;
            }

            @Override
            public Sink<Namespace> namespaceSink() {
                return this.val$nsAddSink;
            }

            @Override
            public Sink<String> commentSink() {
                return this.val$cmtAddSink;
            }
        };
        this.subSink = new RDFSink((Sink)stSubSink, (Sink)nsSubSink, (Sink)cmtSubSink){
            final /* synthetic */ Sink val$stSubSink;
            final /* synthetic */ Sink val$nsSubSink;
            final /* synthetic */ Sink val$cmtSubSink;
            {
                this.val$stSubSink = sink;
                this.val$nsSubSink = sink2;
                this.val$cmtSubSink = sink3;
            }

            @Override
            public Sink<Statement> statementSink() {
                return this.val$stSubSink;
            }

            @Override
            public Sink<Namespace> namespaceSink() {
                return this.val$nsSubSink;
            }

            @Override
            public Sink<String> commentSink() {
                return this.val$cmtSubSink;
            }
        };
        this.stSink = new DiffSink<Statement>((Sink)stAddSink, (Sink)stSubSink){
            final /* synthetic */ Sink val$stAddSink;
            final /* synthetic */ Sink val$stSubSink;
            {
                this.val$stAddSink = sink;
                this.val$stSubSink = sink2;
            }

            public Sink<Statement> getPlus() {
                return this.val$stAddSink;
            }

            public Sink<Statement> getMinus() {
                return this.val$stSubSink;
            }
        };
        this.nsSink = new DiffSink<Namespace>((Sink)nsAddSink, (Sink)nsSubSink){
            final /* synthetic */ Sink val$nsAddSink;
            final /* synthetic */ Sink val$nsSubSink;
            {
                this.val$nsAddSink = sink;
                this.val$nsSubSink = sink2;
            }

            public Sink<Namespace> getPlus() {
                return this.val$nsAddSink;
            }

            public Sink<Namespace> getMinus() {
                return this.val$nsSubSink;
            }
        };
        this.cmtSink = new DiffSink<String>((Sink)cmtAddSink, (Sink)cmtSubSink){
            final /* synthetic */ Sink val$cmtAddSink;
            final /* synthetic */ Sink val$cmtSubSink;
            {
                this.val$cmtAddSink = sink;
                this.val$cmtSubSink = sink2;
            }

            public Sink<String> getPlus() {
                return this.val$cmtAddSink;
            }

            public Sink<String> getMinus() {
                return this.val$cmtSubSink;
            }
        };
        this.clear();
    }

    public Iterator<Resource> contextIterator() {
        return this.contextToCollectorMap.keySet().iterator();
    }

    public RDFDiffSource sourceForContext(Resource context) {
        return this.contextToCollectorMap.get(context);
    }

    public void clear() {
        this.contextToCollectorMap.clear();
        RDFDiffCollector nullCollector = new RDFDiffCollector();
        this.contextToCollectorMap.put(null, nullCollector);
    }

    public void clearContext(Resource context) {
        this.contextToCollectorMap.remove(context);
    }

    @Override
    public RDFSink adderSink() {
        return this.addSink;
    }

    @Override
    public RDFSink subtractorSink() {
        return this.subSink;
    }

    @Override
    public DiffSink<Statement> statementSink() {
        return this.stSink;
    }

    @Override
    public DiffSink<Namespace> namespaceSink() {
        return this.nsSink;
    }

    @Override
    public DiffSink<String> commentSink() {
        return this.cmtSink;
    }
}

