/*
 * Decompiled with CFR 0.152.
 */
package net.frogmouth.chronyjava;

import java.util.HashMap;
import java.util.Map;
import net.frogmouth.chronyjava.Tracking;

public enum Command {
    Null(0, 4),
    Tracking(33, net.frogmouth.chronyjava.Tracking.getPaddingBytes());

    private static final Map<Integer, Command> lookupTable;
    private final int code;
    private final int paddingLength;

    public static Command fromIndex(int identifier) {
        return lookupTable.getOrDefault(identifier, Null);
    }

    private Command(int c, int padding) {
        this.code = c;
        this.paddingLength = padding;
    }

    public int getCode() {
        return this.code;
    }

    public byte[] getBytes() {
        return new byte[]{0, (byte)this.code};
    }

    byte[] getRequestPadding() {
        return new byte[this.paddingLength];
    }

    static {
        lookupTable = new HashMap<Integer, Command>();
        for (Command command : Command.values()) {
            lookupTable.put(command.code, command);
        }
    }
}

