/*
 * Decompiled with CFR 0.152.
 */
package net.frogmouth.chronyjava;

class ParseUtils {
    private static final long FLOAT_EXPONENT_MAGNITUDE_MASK = 63L;
    private static final long FLOAT_EXPONENT_SIGN_MASK = 0x80000000L;
    private static final long FLOAT_COEFFICIENT_MAGNITUDE_MASK = 0xFFFFFFL;
    private static final long FLOAT_COEFFICIENT_SIGN_MASK = 0x1000000L;
    private static final int FLOAT_COEFFICIENT_BITS = 25;

    static double ChronyFloatToJavaDouble(int chronyFloat) {
        long exponent = (long)(chronyFloat >> 25) & 0x3FL;
        if (((long)chronyFloat & 0x80000000L) == 0x80000000L) {
            exponent = -1L * (((exponent ^ 0xFFFFFFFFFFFFFFFFL) & 0x3FL) + 1L);
        }
        long coefficient = (long)chronyFloat & 0xFFFFFFL;
        if (((long)chronyFloat & 0x1000000L) == 0x1000000L) {
            coefficient = -1L * (((coefficient ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFL) + 1L);
        }
        return Math.pow(2.0, exponent - 25L) * (double)coefficient;
    }

    private ParseUtils() {
    }

    static int readUint32(byte[] bytes, int index) {
        int v = (bytes[index] << 24 & 0xFF000000) + (bytes[index + 1] << 16 & 0xFF0000) + (bytes[index + 2] << 8 & 0xFF00) + (bytes[index + 3] & 0xFF);
        return v;
    }

    static int readUint16(byte[] bytes, int index) {
        return (bytes[index] << 8 & 0xFF00) + (bytes[index + 1] & 0xFF);
    }
}

