/*
 * Decompiled with CFR 0.152.
 */
package net.frogmouth.chronyjava;

import net.frogmouth.chronyjava.Command;
import net.frogmouth.chronyjava.ParseUtils;
import net.frogmouth.chronyjava.Reply;
import net.frogmouth.chronyjava.Status;

public class ReplyHeader {
    private short version;
    private short packetType;
    private Command command;
    private Reply reply;
    private Status status;
    private int sequenceNumber;

    static ReplyHeader fromBytes(byte[] bytes) {
        ReplyHeader replyHeader = new ReplyHeader();
        int index = 0;
        replyHeader.setVersion(bytes[index]);
        replyHeader.setPacketType(bytes[++index]);
        ++index;
        ++index;
        int command = ParseUtils.readUint16(bytes, ++index);
        replyHeader.setCommand(Command.fromIndex(command));
        int reply = ParseUtils.readUint16(bytes, index += 2);
        replyHeader.setReply(Reply.fromIndex(reply));
        int status = ParseUtils.readUint16(bytes, index += 2);
        index += 2;
        replyHeader.setStatus(Status.fromIndex(status));
        index += 2;
        index += 2;
        int seq = ParseUtils.readUint32(bytes, index += 2);
        replyHeader.setSequenceNumber(seq);
        return replyHeader;
    }

    public short getVersion() {
        return this.version;
    }

    public void setVersion(short version) {
        this.version = version;
    }

    public short getPacketType() {
        return this.packetType;
    }

    public void setPacketType(short packetType) {
        this.packetType = packetType;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public Reply getReply() {
        return this.reply;
    }

    public void setReply(Reply reply) {
        this.reply = reply;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }
}

