/*
 * Decompiled with CFR 0.152.
 */
package net.frogmouth.chronyjava;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Random;
import net.frogmouth.chronyjava.Command;
import net.frogmouth.chronyjava.Constants;

public class Request {
    private static final byte PROTOCOL_VERSION_6 = 6;
    private byte protocolVersion = (byte)6;
    private Command command = Command.Null;
    private int attempt = 0;
    private int sequenceNumber;

    public Request() {
        Random random = new Random();
        this.sequenceNumber = random.nextInt();
    }

    public byte getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(byte protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.protocolVersion);
        baos.write(1);
        baos.write(0);
        baos.write(0);
        baos.write(this.command.getBytes());
        baos.write(this.uint16ToBytes(this.attempt));
        baos.write(this.intToBytes(this.sequenceNumber));
        baos.write(Constants.REQUEST_PAD1);
        baos.write(Constants.REQUEST_PAD2);
        baos.write(this.command.getRequestPadding());
        return baos.toByteArray();
    }

    public byte[] sendRequest(InetAddress address, int port) throws IOException {
        byte[] request = this.toBytes();
        DatagramPacket packet = new DatagramPacket(request, request.length, address, port);
        DatagramSocket socket = new DatagramSocket();
        socket.send(packet);
        packet = new DatagramPacket(request, request.length);
        socket.receive(packet);
        return packet.getData();
    }

    public byte[] sendRequest() throws IOException {
        return this.sendRequest(InetAddress.getLocalHost(), 323);
    }

    private byte[] uint16ToBytes(int v) {
        if (v < 0 || v > 65535) {
            throw new IllegalArgumentException("out of range");
        }
        return ByteBuffer.allocate(2).putShort((short)v).array();
    }

    private byte[] intToBytes(int v) {
        return ByteBuffer.allocate(4).putInt(v).array();
    }
}

