/*
 * Decompiled with CFR 0.152.
 */
package net.frogmouth.chronyjava;

import java.util.HashMap;
import java.util.Map;

public enum Status {
    Unknown(-1),
    Success(0),
    Failed(1),
    Unauth(2),
    Invalid(3),
    NoSuchSource(4),
    InvalidTS(5),
    NotEnabled(6),
    BadSubnet(7),
    AccessAllowed(8),
    AccessDenied(9),
    NoHostAccess(10),
    SourceAlreadyKnown(11),
    TooManySources(12),
    NoRTC(13),
    BadRTCFile(14),
    Inactive(15),
    BadSample(16),
    InvalidAF(17),
    BadPktVersion(18),
    BadPktLength(19),
    InvalidName(21);

    private static final Map<Integer, Status> lookupTable;
    private final int code;

    public static Status fromIndex(int identifier) {
        return lookupTable.getOrDefault(identifier, Unknown);
    }

    private Status(int c) {
        this.code = c;
    }

    public int getCode() {
        return this.code;
    }

    static {
        lookupTable = new HashMap<Integer, Status>();
        for (Status status : Status.values()) {
            lookupTable.put(status.code, status);
        }
    }
}

