/*
 * Decompiled with CFR 0.152.
 */
package net.frogmouth.chronyjava;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public class TimeSpec {
    private long seconds;
    private long nanoseconds;

    public static TimeSpec fromBytes(byte[] bytes) {
        TimeSpec timeSpec = new TimeSpec();
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        timeSpec.setSeconds(bb.getLong());
        long seconds = (long)bb.getInt(8) & 0xFFFFFFFFL;
        timeSpec.setNanoseconds(seconds);
        return timeSpec;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public void setSeconds(long seconds) {
        this.seconds = seconds;
    }

    public long getNanoseconds() {
        return this.nanoseconds;
    }

    public void setNanoseconds(long nanoseconds) {
        this.nanoseconds = nanoseconds;
    }

    public ZonedDateTime getZonedDateTime() {
        Instant instant = Instant.ofEpochSecond(this.seconds, this.nanoseconds);
        return ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
    }
}

