/*
 * Decompiled with CFR 0.152.
 */
package net.frogmouth.chronyjava;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import net.frogmouth.chronyjava.ParseUtils;
import net.frogmouth.chronyjava.ReplyHeader;
import net.frogmouth.chronyjava.TimeSpec;

public class Tracking {
    private ReplyHeader replyHeader;
    private int refId;
    private int stratum;
    private int leapStatus;
    private TimeSpec timeSpec;
    private double currentCorrection;
    private double lastOffset;
    private double rmsOffset;
    private double freqPPM;
    private double residFreqPPM;
    private double skewPPM;
    private double rootDelay;
    private double rootDispersion;
    private double lastUpdateInterval;

    public static int getPaddingBytes() {
        return 84;
    }

    public static Tracking fromBytes(byte[] bytes) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            Tracking tracking;
            try (DataInputStream dis = new DataInputStream(bais);){
                Tracking tracking2 = new Tracking();
                ReplyHeader replyHeader = ReplyHeader.fromBytes(dis.readNBytes(28));
                tracking2.setReplyHeader(replyHeader);
                tracking2.setRefId(dis.readInt());
                byte[] ipaddr = dis.readNBytes(20);
                tracking2.setStratum(dis.readUnsignedShort());
                tracking2.setLeapStatus(dis.readUnsignedShort());
                tracking2.setTimeSpec(TimeSpec.fromBytes(dis.readNBytes(12)));
                int currentCorrection = dis.readInt();
                tracking2.setCurrentCorrection(ParseUtils.ChronyFloatToJavaDouble(currentCorrection));
                int lastOffset = dis.readInt();
                tracking2.setLastOffset(ParseUtils.ChronyFloatToJavaDouble(lastOffset));
                int rmsOffset = dis.readInt();
                tracking2.setRmsOffset(ParseUtils.ChronyFloatToJavaDouble(rmsOffset));
                int freqPPM = dis.readInt();
                tracking2.setFreqPPM(ParseUtils.ChronyFloatToJavaDouble(freqPPM));
                int residFreqPPM = dis.readInt();
                tracking2.setResidFreqPPM(ParseUtils.ChronyFloatToJavaDouble(residFreqPPM));
                int skewPPM = dis.readInt();
                tracking2.setSkewPPM(ParseUtils.ChronyFloatToJavaDouble(skewPPM));
                int rootDelay = dis.readInt();
                tracking2.setRootDelay(ParseUtils.ChronyFloatToJavaDouble(rootDelay));
                int rootDispersion = dis.readInt();
                tracking2.setRootDispersion(ParseUtils.ChronyFloatToJavaDouble(rootDispersion));
                int lastUpdateInterval = dis.readInt();
                tracking2.setLastUpdateInterval(ParseUtils.ChronyFloatToJavaDouble(lastUpdateInterval));
                tracking = tracking2;
            }
            return tracking;
        }
    }

    public ReplyHeader getReplyHeader() {
        return this.replyHeader;
    }

    public void setReplyHeader(ReplyHeader replyHeader) {
        this.replyHeader = replyHeader;
    }

    public int getRefId() {
        return this.refId;
    }

    public void setRefId(int refId) {
        this.refId = refId;
    }

    public int getStratum() {
        return this.stratum;
    }

    public void setStratum(int stratum) {
        this.stratum = stratum;
    }

    public TimeSpec getTimeSpec() {
        return this.timeSpec;
    }

    public void setTimeSpec(TimeSpec timeSpec) {
        this.timeSpec = timeSpec;
    }

    public int getLeapStatus() {
        return this.leapStatus;
    }

    public void setLeapStatus(int leapSeconds) {
        this.leapStatus = leapSeconds;
    }

    public double getCurrentCorrection() {
        return this.currentCorrection;
    }

    public void setCurrentCorrection(double currentCorrection) {
        this.currentCorrection = currentCorrection;
    }

    public double getLastOffset() {
        return this.lastOffset;
    }

    public void setLastOffset(double lastOffset) {
        this.lastOffset = lastOffset;
    }

    public double getRmsOffset() {
        return this.rmsOffset;
    }

    public void setRmsOffset(double rmsOffset) {
        this.rmsOffset = rmsOffset;
    }

    public double getFreqPPM() {
        return this.freqPPM;
    }

    public void setFreqPPM(double freqPPM) {
        this.freqPPM = freqPPM;
    }

    public double getResidFreqPPM() {
        return this.residFreqPPM;
    }

    public void setResidFreqPPM(double residFreqPPM) {
        this.residFreqPPM = residFreqPPM;
    }

    public double getSkewPPM() {
        return this.skewPPM;
    }

    public void setSkewPPM(double skewPPM) {
        this.skewPPM = skewPPM;
    }

    public double getRootDelay() {
        return this.rootDelay;
    }

    public void setRootDelay(double rootDelay) {
        this.rootDelay = rootDelay;
    }

    public double getRootDispersion() {
        return this.rootDispersion;
    }

    public void setRootDispersion(double rootDispersion) {
        this.rootDispersion = rootDispersion;
    }

    public double getLastUpdateInterval() {
        return this.lastUpdateInterval;
    }

    public void setLastUpdateInterval(double lastUpdateInterval) {
        this.lastUpdateInterval = lastUpdateInterval;
    }
}

