/*
 * Decompiled with CFR 0.152.
 */
package net.gfxmonk.backpressure.akka;

import akka.NotUsed;
import akka.stream.Attributes;
import akka.stream.FlowShape;
import akka.stream.FlowShape$;
import akka.stream.Graph;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import com.timgroup.statsd.StatsDClient;
import java.util.concurrent.atomic.AtomicLong;
import net.gfxmonk.backpressure.akka.BackpressureSensor$;
import net.gfxmonk.backpressure.akka.BackpressureSensor$AkkaFlow$;
import net.gfxmonk.backpressure.internal.Clock;
import net.gfxmonk.backpressure.internal.Logic;
import net.gfxmonk.backpressure.internal.StatsClient;
import net.gfxmonk.backpressure.internal.statsd.StatsdImpl;
import scala.Predef$;
import scala.collection.immutable.Map;

public class BackpressureSensor {
    private final StatsDClient statsClient;
    private final double sampleRate;
    private final Map<String, String> baseTags;

    public static BackpressureSensor apply(StatsDClient statsDClient, double d, Map<String, String> map) {
        return BackpressureSensor$.MODULE$.apply(statsDClient, d, map);
    }

    public static double apply$default$2() {
        return BackpressureSensor$.MODULE$.apply$default$2();
    }

    public static Map<String, String> apply$default$3() {
        return BackpressureSensor$.MODULE$.apply$default$3();
    }

    public BackpressureSensor(StatsDClient statsClient, double sampleRate, Map<String, String> baseTags) {
        this.statsClient = statsClient;
        this.sampleRate = sampleRate;
        this.baseTags = baseTags;
    }

    public <T> Graph<FlowShape<T, T>, NotUsed> flow(String metricPrefix, Map<String, String> tags) {
        StatsdImpl stats = new StatsdImpl(this.statsClient, metricPrefix, (Map)this.baseTags.$plus$plus(tags), this.sampleRate);
        Clock clockImpl = new Clock(){

            public long microsMonotonic() {
                return System.nanoTime() / 1000L;
            }
        };
        return BackpressureSensor$.MODULE$.flow(clockImpl, (StatsClient)stats);
    }

    public <T> Map<String, String> flow$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public static class AkkaFlow<T>
    extends GraphStage<FlowShape<T, T>> {
        public final Logic net$gfxmonk$backpressure$akka$BackpressureSensor$AkkaFlow$$logic;
        private final Inlet in;
        private final Outlet out;
        private final FlowShape shape;

        public AkkaFlow(Logic logic) {
            this.net$gfxmonk$backpressure$akka$BackpressureSensor$AkkaFlow$$logic = logic;
            this.in = Inlet$.MODULE$.apply("in");
            this.out = Outlet$.MODULE$.apply("out");
            this.shape = FlowShape$.MODULE$.of(this.in(), this.out());
        }

        public Inlet<T> in() {
            return this.in;
        }

        public Outlet<T> out() {
            return this.out;
        }

        public FlowShape<T, T> shape() {
            return this.shape;
        }

        public GraphStageLogic createLogic(Attributes attr) {
            AtomicLong upstreamDuration = new AtomicLong(0L);
            return new GraphStageLogic(upstreamDuration, this){
                private final /* synthetic */ AkkaFlow $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.setHandler($outer.in(), new InHandler(upstreamDuration$1, this){
                        private final AtomicLong upstreamDuration$2;
                        private final /* synthetic */ AkkaFlow$$anon$2 $outer;
                        {
                            this.upstreamDuration$2 = upstreamDuration$4;
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public void onPush() {
                            Object element = this.$outer.protected$grab(this.$outer.net$gfxmonk$backpressure$akka$BackpressureSensor$AkkaFlow$_$$anon$$$outer().in());
                            this.upstreamDuration$2.set(this.$outer.net$gfxmonk$backpressure$akka$BackpressureSensor$AkkaFlow$_$$anon$$$outer().net$gfxmonk$backpressure$akka$BackpressureSensor$AkkaFlow$$logic.onWaitComplete());
                            this.$outer.protected$push(this.$outer.net$gfxmonk$backpressure$akka$BackpressureSensor$AkkaFlow$_$$anon$$$outer().out(), element);
                        }
                    });
                    this.setHandler($outer.out(), new OutHandler(upstreamDuration$1, this){
                        private final AtomicLong upstreamDuration$3;
                        private final /* synthetic */ AkkaFlow$$anon$2 $outer;
                        {
                            this.upstreamDuration$3 = upstreamDuration$5;
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public void onPull() {
                            this.$outer.net$gfxmonk$backpressure$akka$BackpressureSensor$AkkaFlow$_$$anon$$$outer().net$gfxmonk$backpressure$akka$BackpressureSensor$AkkaFlow$$logic.onBusyComplete(this.upstreamDuration$3.get());
                            this.$outer.protected$pull(this.$outer.net$gfxmonk$backpressure$akka$BackpressureSensor$AkkaFlow$_$$anon$$$outer().in());
                        }
                    });
                }

                public Object protected$grab(Inlet in) {
                    return this.grab(in);
                }

                public void protected$push(Outlet out, Object elem) {
                    this.push(out, elem);
                }

                public void protected$pull(Inlet in) {
                    this.pull(in);
                }

                public final /* synthetic */ AkkaFlow net$gfxmonk$backpressure$akka$BackpressureSensor$AkkaFlow$_$$anon$$$outer() {
                    return this.$outer;
                }
            };
        }
    }
}

