/*
 * Decompiled with CFR 0.152.
 */
package net.gfxmonk.backpressure.internal.statsd;

import com.timgroup.statsd.StatsDClient;
import java.io.Serializable;
import net.gfxmonk.backpressure.internal.Cause;
import net.gfxmonk.backpressure.internal.FloatMetric;
import net.gfxmonk.backpressure.internal.IntegerMetric;
import net.gfxmonk.backpressure.internal.Metric;
import net.gfxmonk.backpressure.internal.StatsClient;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%b!\u0002\r\u001a\u0001u\u0019\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u0011e\u0002!\u0011!Q\u0001\niB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\")Q\n\u0001C\u0001\u001d\"9Q\u000b\u0001b\u0001\n\u00131\u0006B\u00020\u0001A\u0003%q\u000bC\u0004`\u0001\t\u0007I\u0011\u0002,\t\r\u0001\u0004\u0001\u0015!\u0003X\u0011\u001d\t\u0007A1A\u0005\nYCaA\u0019\u0001!\u0002\u00139\u0006\"B2\u0001\t\u0013!\u0007b\u00026\u0001\u0005\u0004%Ia\u001b\u0005\u0007Y\u0002\u0001\u000b\u0011B3\t\u000f5\u0004!\u0019!C\u0005W\"1a\u000e\u0001Q\u0001\n\u0015DQa\u001c\u0001\u0005\nADQ!\u001e\u0001\u0005BYDa!\u001e\u0001\u0005B\u0005-q\u0001CA\r3!\u0005Q$a\u0007\u0007\u000faI\u0002\u0012A\u000f\u0002\u001e!1Q*\u0006C\u0001\u0003?)a!!\t\u0016\u0001\u0005\r\"AC*uCR\u001cH-S7qY*\u0011!dG\u0001\u0007gR\fGo\u001d3\u000b\u0005qi\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005yy\u0012\u0001\u00042bG.\u0004(/Z:tkJ,'B\u0001\u0011\"\u0003\u001d9g\r_7p].T\u0011AI\u0001\u0004]\u0016$8c\u0001\u0001%UA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\u0004\"a\u000b\u0017\u000e\u0003mI!!L\u000e\u0003\u0017M#\u0018\r^:DY&,g\u000e^\u0001\u0007G2LWM\u001c;\u0004\u0001A\u0011\u0011gN\u0007\u0002e)\u0011!d\r\u0006\u0003iU\n\u0001\u0002^5nOJ|W\u000f\u001d\u0006\u0002m\u0005\u00191m\\7\n\u0005a\u0012$\u0001D*uCR\u001cHi\u00117jK:$\u0018\u0001D7fiJL7\r\u0015:fM&D\bCA\u001eC\u001d\ta\u0004\t\u0005\u0002>M5\taH\u0003\u0002@_\u00051AH]8pizJ!!\u0011\u0014\u0002\rA\u0013X\rZ3g\u0013\t\u0019EI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0003\u001a\nA\u0001^1hgB!1h\u0012\u001e;\u0013\tAEIA\u0002NCB\f!b]1na2,'+\u0019;f!\t)3*\u0003\u0002MM\t1Ai\\;cY\u0016\fa\u0001P5oSRtD#B(R%N#\u0006C\u0001)\u0001\u001b\u0005I\u0002\"\u0002\u0018\u0006\u0001\u0004\u0001\u0004\"B\u001d\u0006\u0001\u0004Q\u0004\"B#\u0006\u0001\u00041\u0005\"B%\u0006\u0001\u0004Q\u0015a\u00045jgR|wM]1n\u001b\u0016$(/[2\u0016\u0003]\u0003\"\u0001W/\u000e\u0003eS!AW.\u0002\t1\fgn\u001a\u0006\u00029\u0006!!.\u0019<b\u0013\t\u0019\u0015,\u0001\tiSN$xn\u001a:b[6+GO]5dA\u0005QAn\\1e\u001b\u0016$(/[2\u0002\u00171|\u0017\rZ'fiJL7\rI\u0001\u000fm\u0006\u0014\u0018.\u00198dK6+GO]5d\u0003=1\u0018M]5b]\u000e,W*\u001a;sS\u000e\u0004\u0013!D2sK\u0006$X\rV1hg\u001a{'\u000f\u0006\u0002fQB\u0019QE\u001a\u001e\n\u0005\u001d4#!B!se\u0006L\b\"B5\r\u0001\u0004Q\u0014!B2bkN,\u0017aC<bSRLgn\u001a+bON,\u0012!Z\u0001\ro\u0006LG/\u001b8h)\u0006<7\u000fI\u0001\tEV\u001c\u0018\u0010V1hg\u0006I!-^:z)\u0006<7\u000fI\u0001\bi\u0006<7OR8s)\t)\u0017\u000fC\u0003j#\u0001\u0007!\u000f\u0005\u0002,g&\u0011Ao\u0007\u0002\u0006\u0007\u0006,8/Z\u0001\b[\u0016\f7/\u001e:f)\u00159(p`A\u0001!\t)\u00030\u0003\u0002zM\t!QK\\5u\u0011\u0015Y(\u00031\u0001}\u0003\u0019iW\r\u001e:jGB\u00111&`\u0005\u0003}n\u0011Q\"\u00138uK\u001e,'/T3ue&\u001c\u0007\"B5\u0013\u0001\u0004\u0011\bbBA\u0002%\u0001\u0007\u0011QA\u0001\u0006m\u0006dW/\u001a\t\u0004K\u0005\u001d\u0011bAA\u0005M\t!Aj\u001c8h)\u001d9\u0018QBA\u000b\u0003/Aaa_\nA\u0002\u0005=\u0001cA\u0016\u0002\u0012%\u0019\u00111C\u000e\u0003\u0017\u0019cw.\u0019;NKR\u0014\u0018n\u0019\u0005\u0006SN\u0001\rA\u001d\u0005\u0007\u0003\u0007\u0019\u0002\u0019\u0001&\u0002\u0015M#\u0018\r^:e\u00136\u0004H\u000e\u0005\u0002Q+M\u0011Q\u0003\n\u000b\u0003\u00037\u0011qAQ;jY\u0012,'\u000f\u0005\u0004&\u0003KQdiT\u0005\u0004\u0003O1#!\u0003$v]\u000e$\u0018n\u001c83\u0001")
public class StatsdImpl
implements StatsClient {
    private final StatsDClient client;
    private final Map<String, String> tags;
    private final double sampleRate;
    private final String histogramMetric;
    private final String loadMetric;
    private final String varianceMetric;
    private final String[] waitingTags;
    private final String[] busyTags;

    private String histogramMetric() {
        return this.histogramMetric;
    }

    private String loadMetric() {
        return this.loadMetric;
    }

    private String varianceMetric() {
        return this.varianceMetric;
    }

    private String[] createTagsFor(String cause) {
        List tagStrings = ((IterableOnceOps)this.tags.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(1).append(k).append(":").append(v).toString();
            }
            throw new MatchError((Object)tuple2);
        })).toList();
        String string = new StringBuilder(6).append("cause:").append(cause).toString();
        return (String[])tagStrings.$colon$colon((Object)string).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private String[] waitingTags() {
        return this.waitingTags;
    }

    private String[] busyTags() {
        return this.busyTags;
    }

    private String[] tagsFor(Cause cause) {
        Cause cause2 = cause;
        if (Cause.Waiting$.MODULE$.equals(cause2)) {
            return this.waitingTags();
        }
        if (Cause.Busy$.MODULE$.equals(cause2)) {
            return this.busyTags();
        }
        throw new MatchError((Object)cause2);
    }

    public void measure(IntegerMetric metric, Cause cause, long value) {
        IntegerMetric integerMetric = metric;
        if (Metric.Duration$.MODULE$.equals(integerMetric)) {
            this.client.histogram(this.histogramMetric(), value, this.sampleRate, this.tagsFor(cause));
            return;
        }
        if (Metric.Variance$.MODULE$.equals(integerMetric)) {
            this.client.count(this.varianceMetric(), value, this.sampleRate, this.tagsFor(cause));
            return;
        }
        throw new MatchError((Object)integerMetric);
    }

    public void measure(FloatMetric metric, Cause cause, double value) {
        FloatMetric floatMetric = metric;
        if (Metric.Load$.MODULE$.equals(floatMetric)) {
            this.client.histogram(this.loadMetric(), value, this.sampleRate, this.tagsFor(cause));
            return;
        }
        throw new MatchError((Object)floatMetric);
    }

    public StatsdImpl(StatsDClient client, String metricPrefix, Map<String, String> tags, double sampleRate) {
        this.client = client;
        this.tags = tags;
        this.sampleRate = sampleRate;
        this.histogramMetric = new StringBuilder(7).append(metricPrefix).append(".micros").toString();
        this.loadMetric = new StringBuilder(5).append(metricPrefix).append(".load").toString();
        this.varianceMetric = new StringBuilder(16).append(metricPrefix).append(".variance.micros").toString();
        this.waitingTags = this.createTagsFor("waiting");
        this.busyTags = this.createTagsFor("busy");
    }
}

