/*
 * Decompiled with CFR 0.152.
 */
package net.gfxmonk.backpressure.internal.statsd;

import com.timgroup.statsd.StatsDClient;
import java.io.Serializable;
import net.gfxmonk.backpressure.internal.Cause;
import net.gfxmonk.backpressure.internal.FloatMetric;
import net.gfxmonk.backpressure.internal.IntegerMetric;
import net.gfxmonk.backpressure.internal.Metric;
import net.gfxmonk.backpressure.internal.StatsClient;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;

public class StatsdImpl
implements StatsClient {
    private final StatsDClient client;
    private final Map<String, String> tags;
    private final double sampleRate;
    private final String histogramMetric;
    private final String loadMetric;
    private final String varianceMetric;
    private final String[] waitingTags;
    private final String[] busyTags;

    public StatsdImpl(StatsDClient client, String metricPrefix, Map<String, String> tags, double sampleRate) {
        this.client = client;
        this.tags = tags;
        this.sampleRate = sampleRate;
        this.histogramMetric = new StringBuilder(7).append(metricPrefix).append(".micros").toString();
        this.loadMetric = new StringBuilder(5).append(metricPrefix).append(".load").toString();
        this.varianceMetric = new StringBuilder(16).append(metricPrefix).append(".variance.micros").toString();
        this.waitingTags = this.createTagsFor("waiting");
        this.busyTags = this.createTagsFor("busy");
    }

    private String[] createTagsFor(String cause) {
        List tagStrings = ((IterableOnceOps)this.tags.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(1).append(k).append(":").append(v).toString();
            }
            throw new MatchError((Object)tuple2);
        })).toList();
        String string = new StringBuilder(6).append("cause:").append(cause).toString();
        return (String[])tagStrings.$colon$colon((Object)string).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private String[] tagsFor(Cause cause) {
        Cause cause2 = cause;
        if (Cause.Waiting$.MODULE$.equals(cause2)) {
            return this.waitingTags;
        }
        if (Cause.Busy$.MODULE$.equals(cause2)) {
            return this.busyTags;
        }
        throw new MatchError((Object)cause2);
    }

    public void measure(IntegerMetric metric, Cause cause, long value) {
        IntegerMetric integerMetric = metric;
        if (Metric.Duration$.MODULE$.equals(integerMetric)) {
            this.client.histogram(this.histogramMetric, value, this.sampleRate, this.tagsFor(cause));
            return;
        }
        if (Metric.Variance$.MODULE$.equals(integerMetric)) {
            this.client.count(this.varianceMetric, value, this.sampleRate, this.tagsFor(cause));
            return;
        }
        throw new MatchError((Object)integerMetric);
    }

    public void measure(FloatMetric metric, Cause cause, double value) {
        FloatMetric floatMetric = metric;
        if (Metric.Load$.MODULE$.equals(floatMetric)) {
            this.client.histogram(this.loadMetric, value, this.sampleRate, this.tagsFor(cause));
            return;
        }
        throw new MatchError((Object)floatMetric);
    }
}

