/*
 * Decompiled with CFR 0.152.
 */
package foperator.backend.kubernetesclient.impl;

import cats.Traverse;
import cats.effect.kernel.Async;
import cats.implicits$;
import cats.kernel.Eq;
import cats.syntax.ApplicativeErrorOps$;
import com.goyeau.kubernetes.client.EventType;
import com.goyeau.kubernetes.client.WatchEvent;
import com.goyeau.kubernetes.client.operation.Creatable;
import com.goyeau.kubernetes.client.operation.Deletable;
import com.goyeau.kubernetes.client.operation.Gettable;
import com.goyeau.kubernetes.client.operation.Listable;
import com.goyeau.kubernetes.client.operation.Replaceable;
import com.goyeau.kubernetes.client.operation.Watchable;
import foperator.Id;
import foperator.ListOptions;
import foperator.StateChange;
import foperator.backend.KubernetesClient;
import foperator.backend.kubernetesclient.impl.HasResourceApi;
import foperator.backend.kubernetesclient.impl.StatusError;
import foperator.internal.Logging;
import foperator.types.ClientError;
import foperator.types.Engine;
import foperator.types.HasStatus;
import foperator.types.ObjectResource;
import fs2.Chunk$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.client.UnexpectedStatus;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Selectable$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.language$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;

public class EngineImpl<IO, T, TList>
implements Engine<IO, KubernetesClient<IO>, T>,
Logging {
    private Logger logger;
    private final HasResourceApi<IO, T, TList> api;
    private final ObjectResource<T> res;
    private final Async<IO> io;

    public EngineImpl(HasResourceApi<IO, T, TList> api, ObjectResource<T> res, Async<IO> io) {
        this.api = api;
        this.res = res;
        this.io = io;
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void foperator$internal$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    private Creatable<IO, T> ns(KubernetesClient<IO> c, Id<T> id) {
        return (Creatable)this.api.namespaceApi(c.underlying(), id.namespace());
    }

    private IO handleResponse(IO status) {
        return (IO)implicits$.MODULE$.toFlatMapOps(status, this.io).flatMap((Function1 & Serializable)st -> st.isSuccess() ? this.io.unit() : this.io.raiseError((Object)new StatusError((Status)st)));
    }

    /*
     * Enabled aggressive block sorting
     */
    public ClientError classifyError(Throwable e) {
        ClientError.Unknown unknown;
        None$ status;
        None$ none$;
        Throwable throwable = e;
        if (throwable instanceof StatusError) {
            StatusError s = (StatusError)throwable;
            none$ = Some$.MODULE$.apply((Object)s.status());
        } else if (throwable instanceof UnexpectedStatus) {
            UnexpectedStatus s = (UnexpectedStatus)throwable;
            none$ = Some$.MODULE$.apply((Object)s.status());
        } else {
            none$ = None$.MODULE$;
        }
        None$ none$2 = status = none$;
        if (none$2 instanceof Some) {
            Status status2 = (Status)((Some)none$2).value();
            Status status3 = Status$.MODULE$.NotFound();
            Status status4 = status2;
            if (!(status3 != null ? !status3.equals(status4) : status4 != null)) {
                unknown = ClientError.NotFound$.MODULE$.apply(e);
                return (ClientError)unknown;
            }
            Status status5 = Status$.MODULE$.Conflict();
            Status status6 = status2;
            if (!(status5 != null ? !status5.equals(status6) : status6 != null)) {
                unknown = ClientError.VersionConflict$.MODULE$.apply(e);
                return (ClientError)unknown;
            }
        }
        unknown = ClientError.Unknown$.MODULE$.apply(e);
        return (ClientError)unknown;
    }

    public IO read(KubernetesClient<IO> c, Id<T> id) {
        Object object = implicits$.MODULE$.catsSyntaxApplicativeError(implicits$.MODULE$.toFunctorOps(((Gettable)this.ns(c, id)).get(id.name()), this.io).map((Function1 & Serializable)t -> Some$.MODULE$.apply(t)), this.io);
        return (IO)ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(object, (Function1 & Serializable)e -> {
            ClientError clientError = this.classifyError((Throwable)e);
            return clientError instanceof ClientError.NotFound ? this.io.pure((Object)None$.MODULE$) : this.io.raiseError(e);
        }, this.io);
    }

    public IO create(KubernetesClient<IO> c, T t) {
        return (IO)this.handleResponse(this.ns(c, this.res.id(t)).create(t));
    }

    public IO update(KubernetesClient<IO> c, T t) {
        return (IO)this.handleResponse(((Replaceable)this.ns(c, this.res.id(t))).replace(t));
    }

    public <St> IO updateStatus(KubernetesClient<IO> c, T t, St st, HasStatus<T, St> sub) {
        return this.handleResponse(this.api.updateStatus(c.underlying(), sub.withStatus(t, st)));
    }

    public IO delete(KubernetesClient<IO> c, Id<T> id) {
        Creatable<IO, T> creatable = this.ns(c, id);
        return (IO)this.handleResponse(((Deletable)creatable).delete(id.name(), ((Deletable)creatable).delete$default$2()));
    }

    public Stream<IO, StateChange<T>> listAndWatch(KubernetesClient<IO> c, ListOptions opts) {
        Creatable ns = (Creatable)this.api.namespaceApi(c.underlying(), opts.namespace());
        Object validateFieldSelector = opts.fieldSelector().nonEmpty() ? this.io.raiseError((Object)new RuntimeException(new StringBuilder(66).append("kubernetes-client backend does not support fieldSelector in opts: ").append(opts).toString())) : this.io.unit();
        Object validateLabels = implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toTraverseOps((Object)opts.labelSelector(), (Traverse)implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable)l -> {
            Object object;
            Object object2;
            String[] stringArray = l.split("=", 2);
            if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object2 = Array$.MODULE$.unapplySeq((Object)stringArray), 2) == 0) {
                String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object2, 0);
                String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object2, 1);
                String k = string;
                String v = string2;
                object = this.io.pure((Object)Tuple2$.MODULE$.apply((Object)k, (Object)v));
            } else {
                object = this.io.raiseError((Object)new RuntimeException(new StringBuilder(77).append("kubernetes-client backend only supports equality-based labels, you provided: ").append((String)l).toString()));
            }
            return object;
        }, this.io), this.io).map((Function1 & Serializable)_$2 -> _$2.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return Stream$.MODULE$.eval(implicits$.MODULE$.toFlatMapOps(validateFieldSelector, this.io).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = x$12;
            return implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toFunctorOps(validateLabels, this.io).map((Function1 & Serializable)labels -> {
                Stream resetState = Stream$.MODULE$.evalUnChunk(implicits$.MODULE$.toFunctorOps(((Listable)ns).list(labels), this.io).map((Function1 & Serializable)tl -> Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StateChange.ResetState[]{StateChange.ResetState$.MODULE$.apply(((Seq)Selectable$.MODULE$.reflectiveSelectableFromLangReflectiveCalls(tl, language$.MODULE$.reflectiveCalls()).selectDynamic("items")).toList())}))));
                Stream updates = ((Watchable)ns).watch(labels);
                return Tuple3$.MODULE$.apply(labels, (Object)resetState, (Object)updates);
            }), this.io).map((Function1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                Map labels = (Map)tuple3._1();
                Stream resetState = (Stream)tuple3._2();
                Stream updates = (Stream)tuple3._3();
                return resetState.$plus$plus(() -> this.listAndWatch$$anonfun$1$$anonfun$2$$anonfun$1(resetState, updates));
            });
        })).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final Stream listAndWatch$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2(Stream maybeReset$1) {
        return maybeReset$1;
    }

    private final Stream listAndWatch$$anonfun$1$$anonfun$2$$anonfun$1(Stream resetState$1, Stream updates$1) {
        return updates$1.zipWithIndex().flatMap((Function1 & Serializable)x$1 -> {
            Stream stream;
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Either either = (Either)tuple2._1();
            if (either instanceof Left) {
                String err = (String)((Left)either).value();
                stream = Stream$.MODULE$.raiseError((Throwable)new RuntimeException(new StringBuilder(27).append("Error watching ").append(this.res.kindDescription()).append(" resources: ").append(err).toString()), RaiseThrowable$.MODULE$.fromApplicativeError(this.io));
                return stream;
            } else {
                Object object;
                if (!(either instanceof Right)) throw new MatchError((Object)tuple2);
                WatchEvent event = (WatchEvent)((Right)either).value();
                long idx = BoxesRunTime.unboxToLong((Object)tuple2._2());
                EventType eventType = event.type();
                if (EventType.ADDED$.MODULE$.equals(eventType) || EventType.MODIFIED$.MODULE$.equals(eventType)) {
                    object = this.io.pure((Object)StateChange.Updated$.MODULE$.apply(event.object()));
                } else if (EventType.DELETED$.MODULE$.equals(eventType)) {
                    object = this.io.pure((Object)StateChange.Deleted$.MODULE$.apply(event.object()));
                } else {
                    if (!EventType.ERROR$.MODULE$.equals(eventType)) throw new MatchError((Object)eventType);
                    object = this.io.raiseError((Object)new RuntimeException(new StringBuilder(27).append("Error watching ").append(this.res.kindDescription()).append(" resources: ").append(event).toString()));
                }
                Object outEvent = object;
                Stream maybeReset = implicits$.MODULE$.catsSyntaxEq((Object)BoxesRunTime.boxToLong((long)idx), (Eq)implicits$.MODULE$.catsKernelStdOrderForLong()).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)0L)) ? resetState$1 : Stream$.MODULE$.empty();
                stream = Stream$.MODULE$.evalUnChunk(implicits$.MODULE$.toFunctorOps(outEvent, this.io).map((Function1 & Serializable)o -> Chunk$.MODULE$.singleton(o))).$plus$plus(() -> EngineImpl.listAndWatch$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2(maybeReset));
            }
            return stream;
        }, NotGiven$.MODULE$.value());
    }
}

