/*
 * Decompiled with CFR 0.152.
 */
package net.gini.dropwizard.gelf.bundles;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import com.yammer.dropwizard.ConfiguredBundle;
import com.yammer.dropwizard.config.Bootstrap;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.Environment;
import com.yammer.dropwizard.logging.AsyncAppender;
import javax.servlet.Filter;
import me.moocar.logbackgelf.GelfAppender;
import net.gini.dropwizard.gelf.config.GelfConfiguration;
import net.gini.dropwizard.gelf.filters.GelfLoggingFilter;
import net.gini.dropwizard.gelf.logging.LogbackFactory;
import org.slf4j.LoggerFactory;

public abstract class GelfLoggingBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    public void run(T configuration, Environment environment) throws Exception {
        GelfConfiguration gelf = this.getConfiguration(configuration);
        if (gelf.isEnabled()) {
            Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
            root.addAppender(AsyncAppender.wrap((Appender)LogbackFactory.buildGelfAppender(gelf, root.getLoggerContext())));
            if (gelf.isRequestLogEnabled()) {
                Logger logger = (Logger)LoggerFactory.getLogger(GelfLoggingFilter.class);
                logger.setAdditive(false);
                LoggerContext context = logger.getLoggerContext();
                GelfAppender appender = LogbackFactory.buildGelfAppender(gelf, context, gelf.getFacility() + "-requests");
                logger.addAppender((Appender)appender);
                environment.addFilter((Filter)new GelfLoggingFilter(), "/*");
            }
        }
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public abstract GelfConfiguration getConfiguration(T var1);
}

