/*
 * Decompiled with CFR 0.152.
 */
package net.gini.dropwizard.gelf.filters;

import com.google.common.base.Stopwatch;
import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class GelfLoggingFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(GelfLoggingFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String authType;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        StringBuilder buf = new StringBuilder(256);
        String address = httpRequest.getHeader("X-Forwarded-For");
        if (address == null) {
            address = request.getRemoteAddr();
        }
        buf.append(address);
        buf.append(" - ");
        String userAgent = httpRequest.getHeader("User-Agent");
        if (userAgent != null) {
            MDC.put((String)"userAgent", (String)userAgent);
        }
        if ((authType = httpRequest.getAuthType()) != null) {
            MDC.put((String)"requestAuth", (String)authType);
            MDC.put((String)"userPrincipal", (String)httpRequest.getUserPrincipal().getName());
            buf.append(httpRequest.getUserPrincipal().getName());
        } else {
            buf.append("-");
        }
        buf.append(" \"");
        buf.append(httpRequest.getMethod());
        buf.append(' ');
        buf.append(httpRequest.getRequestURI());
        buf.append(' ');
        buf.append(request.getProtocol());
        buf.append("\" ");
        CountingHttpServletResponseWrapper responseWrapper = new CountingHttpServletResponseWrapper(httpResponse);
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        chain.doFilter(request, (ServletResponse)responseWrapper);
        stopwatch.stop();
        buf.append(responseWrapper.getStatus());
        buf.append(" ");
        buf.append(responseWrapper.getCount());
        MDC.put((String)"remoteAddress", (String)address);
        MDC.put((String)"httpMethod", (String)httpRequest.getMethod());
        MDC.put((String)"protocol", (String)httpRequest.getProtocol());
        MDC.put((String)"requestUri", (String)httpRequest.getRequestURI());
        MDC.put((String)"requestLength", (String)String.valueOf(httpRequest.getContentLength()));
        MDC.put((String)"requestContentType", (String)httpRequest.getContentType());
        MDC.put((String)"requestEncoding", (String)httpRequest.getCharacterEncoding());
        MDC.put((String)"responseStatus", (String)String.valueOf(responseWrapper.getStatus()));
        MDC.put((String)"responseContentType", (String)responseWrapper.getContentType());
        MDC.put((String)"responseEncoding", (String)responseWrapper.getCharacterEncoding());
        MDC.put((String)"responseTimeNanos", (String)String.valueOf(stopwatch.elapsed(TimeUnit.NANOSECONDS)));
        MDC.put((String)"responseLength", (String)String.valueOf(responseWrapper.getCount()));
        LOG.info(buf.toString());
        MDC.clear();
    }

    public void destroy() {
    }

    private static final class CountingHttpServletResponseWrapper
    extends HttpServletResponseWrapper {
        private CountingServletOutputStream outputStream;

        private CountingHttpServletResponseWrapper(HttpServletResponse response) throws IOException {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.outputStream == null) {
                this.outputStream = new CountingServletOutputStream(this.getResponse().getOutputStream());
            }
            return this.outputStream;
        }

        public long getCount() {
            return this.outputStream == null ? 0L : this.outputStream.getCount();
        }

        public void resetBuffer() {
            super.resetBuffer();
            this.outputStream = null;
        }

        public void reset() {
            super.reset();
            this.outputStream = null;
        }
    }

    private static final class CountingServletOutputStream
    extends ServletOutputStream {
        private final CountingOutputStream outputStream;

        private CountingServletOutputStream(ServletOutputStream servletOutputStream) {
            this.outputStream = new CountingOutputStream((OutputStream)servletOutputStream);
        }

        public void write(int b) throws IOException {
            this.outputStream.write(b);
        }

        public long getCount() {
            return this.outputStream.getCount();
        }
    }
}

