/*
 * Decompiled with CFR 0.152.
 */
package net.gini.dropwizard.gelf.logging;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UncaughtExceptionHandlers {
    private UncaughtExceptionHandlers() {
    }

    public static Thread.UncaughtExceptionHandler systemExit() {
        return new Exiter(Runtime.getRuntime());
    }

    private static final class Exiter
    implements Thread.UncaughtExceptionHandler {
        private static final Logger LOGGER = LoggerFactory.getLogger(Exiter.class);
        private final Runtime runtime;

        private Exiter(Runtime runtime) {
            this.runtime = runtime;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOGGER.error(String.format("Caught an exception in %s.  Shutting down.", t), e);
            this.runtime.exit(1);
        }
    }
}

