/*
 * Decompiled with CFR 0.152.
 */
package net.gini.dropwizard.gelf.config;

import ch.qos.logback.classic.Level;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.yammer.dropwizard.validation.PortRange;
import java.util.TimeZone;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.NotEmpty;

public class GelfConfiguration {
    static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    @JsonProperty
    private boolean enabled = false;
    @JsonProperty
    private boolean requestLogEnabled = false;
    @NotNull
    @JsonProperty
    private Level threshold = Level.ALL;
    @JsonProperty
    @NotEmpty
    private String facility = "GELF";
    @JsonProperty
    @NotEmpty
    private String host = "localhost";
    @JsonProperty
    @PortRange(min=1)
    private int port = 12201;
    @JsonProperty
    @NotNull
    private Optional<String> hostName = Optional.absent();
    @JsonProperty
    private boolean useLoggerName = true;
    @JsonProperty
    private boolean useThreadName = true;
    @JsonProperty
    @NotEmpty
    @Pattern(regexp="0\\.9\\.[56]")
    private String serverVersion = "0.9.6";
    @JsonProperty
    @Min(value=0L)
    private int chunkThreshold = 1000;
    @JsonProperty
    private String messagePattern = "%m%rEx";
    @JsonProperty
    private String shortMessagePattern = null;
    @JsonProperty
    @NotNull
    private ImmutableMap<String, String> additionalFields = ImmutableMap.of();
    @JsonProperty
    @NotNull
    private ImmutableMap<String, String> staticFields = ImmutableMap.of();
    @JsonProperty
    private boolean includeFullMDC = false;
    @JsonProperty
    private boolean useMarker = false;
    @JsonProperty
    @NotNull
    private TimeZone timeZone = UTC;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isRequestLogEnabled() {
        return this.requestLogEnabled;
    }

    public Level getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Level threshold) {
        this.threshold = threshold;
    }

    public String getFacility() {
        return this.facility;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Optional<String> getHostName() {
        return this.hostName;
    }

    public void setHostName(Optional<String> hostName) {
        this.hostName = hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isUseLoggerName() {
        return this.useLoggerName;
    }

    public boolean isUseThreadName() {
        return this.useThreadName;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public int getChunkThreshold() {
        return this.chunkThreshold;
    }

    public String getMessagePattern() {
        return this.messagePattern;
    }

    public String getShortMessagePattern() {
        return this.shortMessagePattern;
    }

    public ImmutableMap<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    public ImmutableMap<String, String> getStaticFields() {
        return this.staticFields;
    }

    public boolean isIncludeFullMDC() {
        return this.includeFullMDC;
    }

    public void setIncludeFullMDC(boolean includeFullMDC) {
        this.includeFullMDC = includeFullMDC;
    }

    public boolean isUseMarker() {
        return this.useMarker;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }
}

