/*
 * Decompiled with CFR 0.152.
 */
package net.gini.dropwizard.gelf.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.Appender;
import com.google.common.base.Optional;
import java.util.TimeZone;
import net.gini.dropwizard.gelf.config.GelfConfiguration;
import net.gini.dropwizard.gelf.logging.LogbackFactory;
import org.slf4j.LoggerFactory;

public final class GelfBootstrap {
    private GelfBootstrap() {
    }

    public static void bootstrap(String name, String host, int port, boolean cleanRootLogger) {
        GelfBootstrap.bootstrap(name, host, port, (Optional<String>)Optional.absent(), cleanRootLogger);
    }

    public static void bootstrap(String name, String host, int port, Optional<String> hostName, boolean cleanRootLogger) {
        GelfConfiguration gelf = new GelfConfiguration();
        gelf.setEnabled(true);
        gelf.setIncludeFullMDC(true);
        gelf.setTimeZone(TimeZone.getDefault());
        gelf.setThreshold(Level.WARN);
        gelf.setHost(host);
        gelf.setPort(port);
        gelf.setHostName(hostName);
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        if (cleanRootLogger) {
            root.detachAndStopAllAppenders();
        }
        root.addAppender((Appender)LogbackFactory.buildGelfAppender(gelf, root.getLoggerContext(), name));
    }
}

