/*
 * Decompiled with CFR 0.152.
 */
package net.gini.dropwizard.gelf.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterAttachable;
import com.google.common.base.Preconditions;
import me.moocar.logbackgelf.GelfAppender;
import net.gini.dropwizard.gelf.config.GelfConfiguration;

public final class LogbackFactory {
    private LogbackFactory() {
    }

    public static GelfAppender buildGelfAppender(GelfConfiguration gelf, LoggerContext context, String facility) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)facility);
        GelfAppender appender = new GelfAppender();
        appender.setContext((Context)context);
        appender.setFacility(facility);
        appender.setGraylog2ServerHost(gelf.getHost());
        appender.setGraylog2ServerPort(gelf.getPort());
        appender.setGraylog2ServerVersion(gelf.getServerVersion());
        appender.setMessagePattern(gelf.getMessagePattern());
        appender.setShortMessagePattern(gelf.getShortMessagePattern());
        appender.setUseLoggerName(gelf.isUseLoggerName());
        appender.setUseThreadName(gelf.isUseThreadName());
        appender.setChunkThreshold(gelf.getChunkThreshold());
        appender.setAdditionalFields(gelf.getAdditionalFields());
        appender.setStaticAdditionalFields(gelf.getStaticFields());
        appender.setIncludeFullMDC(gelf.isIncludeFullMDC());
        appender.setUseMarker(gelf.isUseMarker());
        if (gelf.getHostName().isPresent()) {
            appender.setHostName((String)gelf.getHostName().get());
        }
        LogbackFactory.addThresholdFilter((FilterAttachable<ILoggingEvent>)appender, gelf.getThreshold());
        appender.start();
        return appender;
    }

    public static GelfAppender buildGelfAppender(GelfConfiguration gelf, LoggerContext context) {
        return LogbackFactory.buildGelfAppender(gelf, context, gelf.getFacility());
    }

    private static void addThresholdFilter(FilterAttachable<ILoggingEvent> appender, Level threshold) {
        ThresholdFilter filter = new ThresholdFilter();
        filter.setLevel(threshold.toString());
        filter.start();
        appender.addFilter((Filter)filter);
    }
}

