/*
 * Decompiled with CFR 0.152.
 */
package net.gini.dropwizard.gelf.bundles;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.logging.AsyncAppender;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Duration;
import javax.servlet.Filter;
import me.moocar.logbackgelf.GelfAppender;
import net.gini.dropwizard.gelf.config.GelfConfiguration;
import net.gini.dropwizard.gelf.filters.GelfLoggingFilter;
import net.gini.dropwizard.gelf.logging.LogbackFactory;
import org.slf4j.LoggerFactory;

public abstract class GelfLoggingBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    public void run(T configuration, Environment environment) throws Exception {
        GelfConfiguration gelf = this.getConfiguration(configuration);
        if (gelf.isEnabled()) {
            Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
            root.addAppender((Appender)new AsyncAppender((Appender)LogbackFactory.buildGelfAppender(gelf, root.getLoggerContext()), 128, Duration.milliseconds((long)100L), false));
            if (gelf.isRequestLogEnabled()) {
                Logger logger = (Logger)LoggerFactory.getLogger(GelfLoggingFilter.class);
                logger.setAdditive(false);
                LoggerContext context = logger.getLoggerContext();
                GelfAppender appender = LogbackFactory.buildGelfAppender(gelf, context, gelf.getFacility() + "-requests");
                logger.addAppender((Appender)appender);
                environment.servlets().addFilter("gelf", (Filter)new GelfLoggingFilter());
            }
        }
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public abstract GelfConfiguration getConfiguration(T var1);
}

