/*
 * Decompiled with CFR 0.152.
 */
package net.gini.dropwizard.gelf.filters;

import com.google.common.base.Optional;
import com.google.common.base.Stopwatch;
import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class GelfLoggingFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(GelfLoggingFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        StringBuilder buf = new StringBuilder(256);
        Optional address = Optional.fromNullable((Object)httpRequest.getHeader("X-Forwarded-For"));
        String clientAddress = (String)address.or((Object)request.getRemoteAddr());
        buf.append(clientAddress);
        buf.append(" - ");
        String authType = httpRequest.getAuthType();
        if (authType != null) {
            buf.append(httpRequest.getUserPrincipal().getName());
        } else {
            buf.append("-");
        }
        buf.append(" \"");
        buf.append(httpRequest.getMethod());
        buf.append(' ');
        buf.append(httpRequest.getRequestURI());
        buf.append(' ');
        buf.append(request.getProtocol());
        buf.append("\" ");
        CountingHttpServletResponseWrapper responseWrapper = new CountingHttpServletResponseWrapper(httpResponse);
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        try {
            chain.doFilter(request, (ServletResponse)responseWrapper);
        }
        finally {
            stopwatch.stop();
            buf.append(responseWrapper.getStatus());
            buf.append(" ");
            buf.append(responseWrapper.getCount());
            String userAgent = httpRequest.getHeader("User-Agent");
            if (userAgent != null) {
                MDC.put((String)"userAgent", (String)userAgent);
            }
            if (authType != null) {
                MDC.put((String)"requestAuth", (String)authType);
                MDC.put((String)"userPrincipal", (String)httpRequest.getUserPrincipal().getName());
            }
            MDC.put((String)"remoteAddress", (String)clientAddress);
            MDC.put((String)"httpMethod", (String)httpRequest.getMethod());
            MDC.put((String)"protocol", (String)httpRequest.getProtocol());
            MDC.put((String)"requestUri", (String)httpRequest.getRequestURI());
            MDC.put((String)"requestLength", (String)String.valueOf(httpRequest.getContentLength()));
            MDC.put((String)"requestContentType", (String)httpRequest.getContentType());
            MDC.put((String)"requestEncoding", (String)httpRequest.getCharacterEncoding());
            MDC.put((String)"responseStatus", (String)String.valueOf(responseWrapper.getStatus()));
            MDC.put((String)"responseContentType", (String)responseWrapper.getContentType());
            MDC.put((String)"responseEncoding", (String)responseWrapper.getCharacterEncoding());
            MDC.put((String)"responseTimeNanos", (String)String.valueOf(stopwatch.elapsed(TimeUnit.NANOSECONDS)));
            MDC.put((String)"responseLength", (String)String.valueOf(responseWrapper.getCount()));
            LOG.info(buf.toString());
            this.clearMDC();
        }
    }

    public void destroy() {
    }

    private void clearMDC() {
        MDC.remove((String)"userAgent");
        MDC.remove((String)"requestAuth");
        MDC.remove((String)"userPrincipal");
        MDC.remove((String)"remoteAddress");
        MDC.remove((String)"httpMethod");
        MDC.remove((String)"protocol");
        MDC.remove((String)"requestUri");
        MDC.remove((String)"requestLength");
        MDC.remove((String)"requestContentType");
        MDC.remove((String)"requestEncoding");
        MDC.remove((String)"responseStatus");
        MDC.remove((String)"responseContentType");
        MDC.remove((String)"responseEncoding");
        MDC.remove((String)"responseTimeNanos");
        MDC.remove((String)"responseLength");
    }

    private final class AdditionalKeys {
        public static final String USER_AGENT = "userAgent";
        public static final String REQ_AUTH = "requestAuth";
        public static final String PRINCIPAL = "userPrincipal";
        public static final String REMOTE_ADDRESS = "remoteAddress";
        public static final String HTTP_METHOD = "httpMethod";
        public static final String PROTCOL = "protocol";
        public static final String REQ_URI = "requestUri";
        public static final String REQ_LENGTH = "requestLength";
        public static final String REQ_CONTENT_TYPE = "requestContentType";
        public static final String REQ_ENCODING = "requestEncoding";
        public static final String REQ_STATUS = "responseStatus";
        public static final String RESP_CONTENT_TYPE = "responseContentType";
        public static final String RESP_ENCODING = "responseEncoding";
        public static final String RESP_TIME = "responseTimeNanos";
        public static final String RESP_LENGTH = "responseLength";

        private AdditionalKeys() {
        }
    }

    private static final class CountingHttpServletResponseWrapper
    extends HttpServletResponseWrapper {
        private CountingServletOutputStream outputStream;

        private CountingHttpServletResponseWrapper(HttpServletResponse response) throws IOException {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.outputStream == null) {
                this.outputStream = new CountingServletOutputStream(this.getResponse().getOutputStream());
            }
            return this.outputStream;
        }

        public long getCount() {
            return this.outputStream == null ? 0L : this.outputStream.getCount();
        }

        public void resetBuffer() {
            super.resetBuffer();
            this.outputStream = null;
        }

        public void reset() {
            super.reset();
            this.outputStream = null;
        }
    }

    private static final class CountingServletOutputStream
    extends ServletOutputStream {
        private final CountingOutputStream outputStream;

        private CountingServletOutputStream(ServletOutputStream servletOutputStream) {
            this.outputStream = new CountingOutputStream((OutputStream)servletOutputStream);
        }

        public void write(int b) throws IOException {
            this.outputStream.write(b);
        }

        public long getCount() {
            return this.outputStream.getCount();
        }
    }
}

