/*
 * Decompiled with CFR 0.152.
 */
package net.gini.dropwizard.gelf.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.spi.FilterAttachable;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.logging.AbstractAppenderFactory;
import io.dropwizard.validation.PortRange;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import me.moocar.logbackgelf.GelfAppender;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.valuehandling.UnwrapValidatedValue;

@JsonTypeName(value="gelf")
public class GelfAppenderFactory
extends AbstractAppenderFactory {
    @JsonProperty
    @NotNull
    private Level threshold = Level.ALL;
    @JsonProperty
    @NotNull
    @UnwrapValidatedValue
    private Optional<String> facility = Optional.absent();
    @JsonProperty
    @NotEmpty
    private String host = "localhost";
    @JsonProperty
    @PortRange(min=1)
    private int port = 12201;
    @JsonProperty
    @NotNull
    @UnwrapValidatedValue
    private Optional<String> hostName = Optional.absent();
    @JsonProperty
    private boolean useLoggerName = true;
    @JsonProperty
    private boolean useThreadName = true;
    @JsonProperty
    @NotEmpty
    @Pattern(regexp="0\\.9\\.[56]")
    private String serverVersion = "0.9.6";
    @JsonProperty
    @Min(value=0L)
    private int chunkThreshold = 1000;
    @JsonProperty
    private String messagePattern = "%m%rEx";
    @JsonProperty
    private String shortMessagePattern = null;
    @JsonProperty
    @NotNull
    private ImmutableMap<String, String> additionalFields = ImmutableMap.of();
    @JsonProperty
    @NotNull
    private ImmutableMap<String, String> staticFields = ImmutableMap.of();
    @JsonProperty
    @NotNull
    private ImmutableMap<String, String> fieldTypes = ImmutableMap.of();
    @JsonProperty
    private boolean includeFullMDC = false;
    @JsonProperty
    private boolean useMarker = false;

    public Level getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Level threshold) {
        this.threshold = threshold;
    }

    public Optional<String> getFacility() {
        return this.facility;
    }

    public void setFacility(Optional<String> facility) {
        this.facility = facility;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Optional<String> getHostName() {
        return this.hostName;
    }

    public void setHostName(Optional<String> hostName) {
        this.hostName = hostName;
    }

    public boolean isUseLoggerName() {
        return this.useLoggerName;
    }

    public void setUseLoggerName(boolean useLoggerName) {
        this.useLoggerName = useLoggerName;
    }

    public boolean isUseThreadName() {
        return this.useThreadName;
    }

    public void setUseThreadName(boolean useThreadName) {
        this.useThreadName = useThreadName;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public int getChunkThreshold() {
        return this.chunkThreshold;
    }

    public void setChunkThreshold(int chunkThreshold) {
        this.chunkThreshold = chunkThreshold;
    }

    public String getMessagePattern() {
        return this.messagePattern;
    }

    public void setMessagePattern(String messagePattern) {
        this.messagePattern = messagePattern;
    }

    public String getShortMessagePattern() {
        return this.shortMessagePattern;
    }

    public void setShortMessagePattern(String shortMessagePattern) {
        this.shortMessagePattern = shortMessagePattern;
    }

    public ImmutableMap<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    public void setAdditionalFields(ImmutableMap<String, String> additionalFields) {
        this.additionalFields = additionalFields;
    }

    public ImmutableMap<String, String> getStaticFields() {
        return this.staticFields;
    }

    public void setStaticFields(ImmutableMap<String, String> staticFields) {
        this.staticFields = staticFields;
    }

    public ImmutableMap<String, String> getFieldTypes() {
        return this.fieldTypes;
    }

    public void setFieldTypes(ImmutableMap<String, String> fieldTypes) {
        this.fieldTypes = fieldTypes;
    }

    public boolean isIncludeFullMDC() {
        return this.includeFullMDC;
    }

    public void setIncludeFullMDC(boolean includeFullMDC) {
        this.includeFullMDC = includeFullMDC;
    }

    public boolean isUseMarker() {
        return this.useMarker;
    }

    public void setUseMarker(boolean useMarker) {
        this.useMarker = useMarker;
    }

    public Appender<ILoggingEvent> build(LoggerContext context, String applicationName, Layout<ILoggingEvent> layout) {
        Preconditions.checkNotNull((Object)context);
        GelfAppender appender = new GelfAppender();
        appender.setContext((Context)context);
        appender.setFacility((String)this.facility.or((Object)applicationName));
        appender.setGraylog2ServerHost(this.host);
        appender.setGraylog2ServerPort(this.port);
        appender.setGraylog2ServerVersion(this.serverVersion);
        appender.setMessagePattern(this.messagePattern);
        appender.setShortMessagePattern(this.shortMessagePattern);
        appender.setUseLoggerName(this.useLoggerName);
        appender.setUseThreadName(this.useThreadName);
        appender.setChunkThreshold(this.chunkThreshold);
        appender.setAdditionalFields(this.additionalFields);
        appender.setStaticAdditionalFields(this.staticFields);
        appender.setFieldTypes(this.fieldTypes);
        appender.setIncludeFullMDC(this.includeFullMDC);
        appender.setUseMarker(this.useMarker);
        if (this.hostName.isPresent()) {
            appender.setHostName((String)this.hostName.get());
        }
        this.addThresholdFilter((FilterAttachable)appender, this.threshold);
        appender.start();
        return this.wrapAsync((Appender)appender);
    }
}

