/*
 * Decompiled with CFR 0.152.
 */
package net.gini.dropwizard.gelf.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.google.common.base.Optional;
import net.gini.dropwizard.gelf.logging.GelfAppenderFactory;
import org.slf4j.LoggerFactory;

public final class GelfBootstrap {
    private GelfBootstrap() {
    }

    public static void bootstrap(String name, String host, int port, boolean cleanRootLogger) {
        GelfBootstrap.bootstrap(name, host, port, (Optional<String>)Optional.absent(), cleanRootLogger);
    }

    public static void bootstrap(String name, String host, int port, Optional<String> hostName, boolean cleanRootLogger) {
        GelfAppenderFactory gelf = new GelfAppenderFactory();
        gelf.setIncludeFullMDC(true);
        gelf.setThreshold(Level.WARN);
        gelf.setHost(host);
        gelf.setPort(port);
        gelf.setHostName(hostName);
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        if (cleanRootLogger) {
            root.detachAndStopAllAppenders();
        }
        root.addAppender(gelf.build(root.getLoggerContext(), name, null));
    }
}

