/*
 * Decompiled with CFR 0.152.
 */
package net.gini.dropwizard.gelf.logging;

import java.util.Objects;
import net.gini.dropwizard.gelf.logging.GelfBootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UncaughtExceptionHandlers {
    private UncaughtExceptionHandlers() {
    }

    public static LoggingSystemExitBuilder loggingSystemExitBuilder(String facility, String host) {
        return new LoggingSystemExitBuilder(facility, host);
    }

    public static Thread.UncaughtExceptionHandler systemExit() {
        return new Exiter(Runtime.getRuntime());
    }

    private static final class Exiter
    implements Thread.UncaughtExceptionHandler {
        private final Runtime runtime;

        private Exiter(Runtime runtime) {
            this.runtime = Objects.requireNonNull(runtime);
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            System.err.print(String.format("Caught an exception in %s.  Shutting down! ", t));
            e.printStackTrace(System.err);
            this.runtime.exit(1);
        }
    }

    private static final class LoggingExiter
    implements Thread.UncaughtExceptionHandler {
        private static final Logger LOGGER = LoggerFactory.getLogger(Exiter.class);
        private final Runtime runtime;
        private final String name;
        private final String host;
        private final int port;
        private final boolean cleanRootLogger;
        private final boolean logToStderr;

        private LoggingExiter(Runtime runtime, String name, String host, int port, boolean cleanRootLogger, boolean logToStderr) {
            this.runtime = runtime;
            this.name = name;
            this.host = host;
            this.port = port;
            this.cleanRootLogger = cleanRootLogger;
            this.logToStderr = logToStderr;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            GelfBootstrap.bootstrap(this.name, this.host, this.port, this.cleanRootLogger);
            String msg = String.format("Caught an exception in %s.  Shutting down", t);
            LOGGER.error(msg, e);
            if (this.logToStderr) {
                System.err.print(msg);
                System.err.print("! ");
                e.printStackTrace(System.err);
            }
            this.getRootLogger().detachAndStopAllAppenders();
            this.runtime.exit(1);
        }

        private ch.qos.logback.classic.Logger getRootLogger() {
            return (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        }
    }

    public static final class LoggingSystemExitBuilder {
        private String facility;
        private String host;
        private int port = 12201;
        private boolean cleanRootLogger = false;
        private boolean logToStderr = true;

        LoggingSystemExitBuilder(String facility, String host) {
            this.facility = Objects.requireNonNull(facility);
            this.host = Objects.requireNonNull(host);
        }

        public LoggingSystemExitBuilder port(int port) {
            this.port = port;
            return this;
        }

        public LoggingSystemExitBuilder cleanRootLogger(boolean cleanRootLogger) {
            this.cleanRootLogger = cleanRootLogger;
            return this;
        }

        public LoggingSystemExitBuilder logToStderr(boolean logToStderr) {
            this.logToStderr = logToStderr;
            return this;
        }

        public Thread.UncaughtExceptionHandler build() {
            return new LoggingExiter(Runtime.getRuntime(), this.facility, this.host, this.port, this.cleanRootLogger, this.logToStderr);
        }
    }
}

