/*
 * Decompiled with CFR 0.152.
 */
package net.gini.dropwizard.gelf.logging;

import biz.paluch.logging.gelf.logback.GelfLogbackAppender;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.helpers.NOPAppender;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.logging.AbstractAppenderFactory;
import io.dropwizard.logging.async.AsyncAppenderFactory;
import io.dropwizard.logging.filter.LevelFilterFactory;
import io.dropwizard.logging.layout.LayoutFactory;
import io.dropwizard.validation.PortRange;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

@JsonTypeName(value="gelf")
public class GelfAppenderFactory
extends AbstractAppenderFactory<ILoggingEvent> {
    @JsonProperty
    private boolean enabled = true;
    @JsonProperty
    @NotNull
    private Level threshold = Level.ALL;
    @JsonProperty
    private Optional<String> facility = Optional.empty();
    @JsonProperty
    @NotEmpty
    private String host = "localhost";
    @JsonProperty
    @PortRange
    private int port = 12201;
    @JsonProperty
    private Optional<String> originHost = Optional.empty();
    @JsonProperty
    @NotNull
    private ImmutableMap<String, String> additionalFields = ImmutableMap.of();
    @JsonProperty
    @NotNull
    private ImmutableMap<String, String> additionalFieldTypes = ImmutableMap.of();
    @JsonProperty
    private boolean includeFullMDC = false;
    @JsonProperty
    @NotNull
    private Collection<String> mdcFields = ImmutableList.of();
    @JsonProperty
    @NotNull
    private Collection<String> dynamicMdcFields = ImmutableList.of();
    @JsonProperty
    private boolean mdcProfiling = false;
    @JsonProperty
    private boolean extractStackTrace = false;
    @JsonProperty
    private boolean filterStackTrace = false;
    @JsonProperty
    @Min(value=0L)
    private int maximumMessageSize = 8192;
    @JsonProperty
    @NotNull
    private String timestampPattern = "yyyy-MM-dd HH:mm:ss,SSSS";

    public Level getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Level threshold) {
        this.threshold = threshold;
    }

    public Optional<String> getFacility() {
        return this.facility;
    }

    public void setFacility(Optional<String> facility) {
        this.facility = facility;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Optional<String> getOriginHost() {
        return this.originHost;
    }

    public void setOriginHost(Optional<String> originHost) {
        this.originHost = originHost;
    }

    public ImmutableMap<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    public void setAdditionalFields(ImmutableMap<String, String> additionalFields) {
        this.additionalFields = additionalFields;
    }

    public ImmutableMap<String, String> getAdditionalFieldTypes() {
        return this.additionalFieldTypes;
    }

    public void setAdditionalFieldTypes(ImmutableMap<String, String> additionalFieldTypes) {
        this.additionalFieldTypes = additionalFieldTypes;
    }

    public boolean isIncludeFullMDC() {
        return this.includeFullMDC;
    }

    public void setIncludeFullMDC(boolean includeFullMDC) {
        this.includeFullMDC = includeFullMDC;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Collection<String> getMdcFields() {
        return this.mdcFields;
    }

    public void setMdcFields(Collection<String> mdcFields) {
        this.mdcFields = mdcFields;
    }

    public Collection<String> getDynamicMdcFields() {
        return this.dynamicMdcFields;
    }

    public void setDynamicMdcFields(Collection<String> dynamicMdcFields) {
        this.dynamicMdcFields = dynamicMdcFields;
    }

    public boolean isMdcProfiling() {
        return this.mdcProfiling;
    }

    public void setMdcProfiling(boolean mdcProfiling) {
        this.mdcProfiling = mdcProfiling;
    }

    public boolean isExtractStackTrace() {
        return this.extractStackTrace;
    }

    public void setExtractStackTrace(boolean extractStackTrace) {
        this.extractStackTrace = extractStackTrace;
    }

    public boolean isFilterStackTrace() {
        return this.filterStackTrace;
    }

    public void setFilterStackTrace(boolean filterStackTrace) {
        this.filterStackTrace = filterStackTrace;
    }

    public int getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    public void setMaximumMessageSize(int maximumMessageSize) {
        this.maximumMessageSize = maximumMessageSize;
    }

    public String getTimestampPattern() {
        return this.timestampPattern;
    }

    public void setTimestampPattern(String timestampPattern) {
        this.timestampPattern = timestampPattern;
    }

    public Appender<ILoggingEvent> build(LoggerContext context, String applicationName, LayoutFactory<ILoggingEvent> layoutFactory, LevelFilterFactory<ILoggingEvent> levelFilterFactory, AsyncAppenderFactory<ILoggingEvent> asyncAppenderFactory) {
        if (!this.enabled) {
            NOPAppender appender = new NOPAppender();
            appender.start();
            return appender;
        }
        GelfLogbackAppender appender = new GelfLogbackAppender();
        appender.setContext((Context)context);
        appender.setName("dropwizard-gelf");
        appender.setFacility(this.facility.orElse(applicationName));
        appender.setGraylogHost(this.host);
        appender.setGraylogPort(this.port);
        appender.setVersion("1.1");
        appender.setAdditionalFields(this.buildFieldsSpec((Map<String, String>)this.additionalFields));
        appender.setAdditionalFieldTypes(this.buildFieldsSpec((Map<String, String>)this.additionalFieldTypes));
        appender.setMdcFields(this.buildMdcFieldsSpec(this.mdcFields));
        appender.setDynamicMdcFields(this.buildMdcFieldsSpec(this.dynamicMdcFields));
        appender.setIncludeFullMdc(true);
        appender.setMdcProfiling(this.mdcProfiling);
        appender.setExtractStackTrace(this.extractStackTrace);
        appender.setFilterStackTrace(this.filterStackTrace);
        appender.setMaximumMessageSize(this.maximumMessageSize);
        appender.setTimestampPattern(this.timestampPattern);
        if (this.originHost.isPresent()) {
            appender.setOriginHost(this.originHost.get());
        }
        appender.addFilter(levelFilterFactory.build(this.threshold));
        this.getFilterFactories().stream().forEach(f -> appender.addFilter(f.build()));
        appender.start();
        return this.wrapAsync((Appender)appender, asyncAppenderFactory);
    }

    private String buildMdcFieldsSpec(@NotNull Collection<String> fields) {
        return Joiner.on((char)',').skipNulls().join(fields);
    }

    private String buildFieldsSpec(@NotNull Map<String, String> fields) {
        return Joiner.on((char)',').withKeyValueSeparator("=").useForNull("null").join(fields);
    }
}

