/*
 * Decompiled with CFR 0.152.
 */
package net.gini.dropwizard.gelf.filters;

import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

final class CountingServletOutputStream
extends ServletOutputStream {
    private final ServletOutputStream underlyingStream;
    private final CountingOutputStream outputStream;

    CountingServletOutputStream(ServletOutputStream servletOutputStream) {
        this.underlyingStream = servletOutputStream;
        this.outputStream = new CountingOutputStream((OutputStream)servletOutputStream);
    }

    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
    }

    public void close() throws IOException {
        this.underlyingStream.close();
    }

    public void flush() throws IOException {
        this.underlyingStream.flush();
    }

    public long getCount() {
        return this.outputStream.getCount();
    }

    public boolean isReady() {
        return this.underlyingStream.isReady();
    }

    public void setWriteListener(WriteListener writeListener) {
        this.underlyingStream.setWriteListener(writeListener);
    }
}

