/*
 * Decompiled with CFR 0.152.
 */
package net.gini.dropwizard.gelf.logging;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import io.dropwizard.logging.async.AsyncAppenderFactory;
import io.dropwizard.logging.async.AsyncLoggingEventAppenderFactory;
import io.dropwizard.logging.filter.LevelFilterFactory;
import io.dropwizard.logging.filter.ThresholdLevelFilterFactory;
import java.util.Optional;
import net.gini.dropwizard.gelf.logging.GelfAppenderFactory;
import org.slf4j.LoggerFactory;

public final class GelfBootstrap {
    private GelfBootstrap() {
    }

    public static void bootstrap(String name, String host, int port, boolean cleanRootLogger) {
        GelfBootstrap.bootstrap(name, host, port, Optional.empty(), cleanRootLogger);
    }

    public static void bootstrap(String name, String host, int port, Optional<String> hostName, boolean cleanRootLogger) {
        GelfAppenderFactory gelf = new GelfAppenderFactory();
        gelf.setIncludeFullMDC(true);
        gelf.setThreshold("WARN");
        gelf.setHost(host);
        gelf.setPort(port);
        gelf.setOriginHost(hostName);
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        if (cleanRootLogger) {
            root.detachAndStopAllAppenders();
        }
        root.addAppender(gelf.build(root.getLoggerContext(), name, null, (LevelFilterFactory<ILoggingEvent>)new ThresholdLevelFilterFactory(), (AsyncAppenderFactory<ILoggingEvent>)new AsyncLoggingEventAppenderFactory()));
    }
}

