/*
 * Decompiled with CFR 0.152.
 */
package net.gleamynode.netty2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.gleamynode.netty2.Check;
import net.gleamynode.netty2.Event;
import net.gleamynode.netty2.EventQueue;
import net.gleamynode.netty2.EventType;
import net.gleamynode.netty2.Message;
import net.gleamynode.netty2.Session;
import net.gleamynode.netty2.ThreadPooledEventDispatcher;

public abstract class AbstractThreadPooledEventDispatcher
implements ThreadPooledEventDispatcher {
    private String threadNamePrefix = "netty-evt";
    private boolean started;
    protected final List workers = new ArrayList();
    private int threadPoolSize = 0;
    private int threadPriority = 5;
    private int threadId = 0;

    protected AbstractThreadPooledEventDispatcher() {
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        if (this.threadPoolSize <= 0) {
            throw new IllegalStateException("threadPoolSize is not set");
        }
        this.started = true;
        this.forkThreads(this.threadPoolSize);
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.forkThreads(-this.threadPoolSize);
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public synchronized void setThreadPoolSize(int newSize) {
        Check.threadPoolSize(newSize);
        if (this.started) {
            throw new IllegalStateException("Thread pool size cannot be changed while running.");
        }
        this.threadPoolSize = newSize;
    }

    private void forkThreads(int delta) {
        if (delta == 0) {
            return;
        }
        if (delta > 0) {
            while (delta > 0) {
                this.workers.add(this.newWorker());
                --delta;
            }
        } else {
            while (delta < 0) {
                AbstractWorker worker = this.removeWorker();
                if (worker != null) {
                    this.workers.remove(worker);
                }
                ++delta;
            }
        }
    }

    protected abstract AbstractWorker newWorker();

    protected abstract AbstractWorker removeWorker();

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public synchronized void setThreadPriority(int newPriority) {
        Check.threadPriority(newPriority);
        this.threadPriority = newPriority;
        if (this.isStarted()) {
            Iterator it = this.workers.iterator();
            while (it.hasNext()) {
                AbstractWorker worker = (AbstractWorker)it.next();
                worker.setPriority(newPriority);
            }
        }
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        Check.notNull(threadNamePrefix, "threadNamePrefix");
        this.threadNamePrefix = threadNamePrefix;
    }

    public void flush() {
    }

    protected abstract class AbstractWorker
    extends Thread {
        protected final EventQueue localEventQueue;

        protected AbstractWorker(EventQueue eventQueue) {
            super(AbstractThreadPooledEventDispatcher.this.getThreadNamePrefix() + '-' + AbstractThreadPooledEventDispatcher.this.threadId++);
            this.setPriority(AbstractThreadPooledEventDispatcher.this.getThreadPriority());
            this.setDaemon(true);
            this.localEventQueue = eventQueue;
            super.start();
        }

        public final void run() {
            Event event;
            EventType type;
            while (AbstractThreadPooledEventDispatcher.this.isStarted() && (type = (event = this.localEventQueue.fetch()).getType()) != EventType.FEWER_THREADS) {
                Session session = event.getSession();
                Object item = event.getItem();
                try {
                    if (type == EventType.RECEIVED) {
                        session.fireMessageReceived((Message)item);
                        continue;
                    }
                    if (type == EventType.SENT) {
                        session.fireMessageSent((Message)item);
                        continue;
                    }
                    if (type == EventType.EXCEPTION) {
                        session.fireExceptionCaught((Throwable)item);
                        continue;
                    }
                    if (type == EventType.DISCONNECTED) {
                        this.onDisconnection(session);
                        session.fireConnectionClosed();
                        continue;
                    }
                    if (type == EventType.CONNECTED) {
                        session.fireConnectionEstablished();
                        continue;
                    }
                    if (type == EventType.IDLE) {
                        session.fireSessionIdle();
                        continue;
                    }
                    throw new RuntimeException("Invalid event: " + type);
                }
                catch (Throwable t) {
                    session.fireExceptionCaught(t);
                }
            }
            this.onEnd();
        }

        protected abstract void onDisconnection(Session var1);

        protected abstract void onEnd();
    }
}

