/*
 * Decompiled with CFR 0.152.
 */
package net.gleamynode.netty2;

import java.nio.ByteBuffer;
import net.gleamynode.netty2.Queue;

class ByteBufferPool {
    static final int DEFAULT_BUF_SIZE = 8192;
    private static Queue buffers = new Queue(16);

    ByteBufferPool() {
    }

    public static synchronized ByteBuffer open() {
        ByteBuffer buf = (ByteBuffer)buffers.pop();
        if (buf == null) {
            buf = ByteBuffer.allocateDirect(8192);
        } else {
            buf.clear();
        }
        return buf;
    }

    public static synchronized void close(ByteBuffer buf) {
        buffers.push(buf);
    }

    static {
        buffers.open();
    }
}

