/*
 * Decompiled with CFR 0.152.
 */
package net.gleamynode.netty2;

import java.util.Arrays;
import net.gleamynode.netty2.Event;

class EventQueue {
    private Event[] events;
    private int first = 0;
    private int last = 0;
    private int size = 0;
    private int waitingForNewItem;

    public EventQueue(int initialCapacity) {
        this.events = new Event[initialCapacity];
    }

    public synchronized void clear() {
        Arrays.fill(this.events, null);
        this.first = 0;
        this.last = 0;
        this.size = 0;
    }

    public synchronized Event fetch() {
        Event e;
        ++this.waitingForNewItem;
        while ((e = this.fetchNow0()) == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        --this.waitingForNewItem;
        return e;
    }

    public synchronized Event fetchNow() {
        return this.fetchNow0();
    }

    private Event fetchNow0() {
        if (this.size == 0) {
            return null;
        }
        Event event = this.events[this.first];
        this.events[this.first++] = null;
        if (this.first == this.events.length) {
            this.first = 0;
        }
        --this.size;
        return event;
    }

    public synchronized void push(Event event) {
        if (this.size == this.events.length) {
            int oldLen = this.events.length;
            Event[] newEvents = new Event[oldLen * 2];
            if (this.first < this.last) {
                System.arraycopy(this.events, this.first, newEvents, 0, this.last - this.first);
            } else {
                System.arraycopy(this.events, this.first, newEvents, 0, oldLen - this.first);
                System.arraycopy(this.events, 0, newEvents, oldLen - this.first, this.last);
            }
            this.first = 0;
            this.last = oldLen;
            this.events = newEvents;
        }
        this.events[this.last++] = event;
        if (this.last == this.events.length) {
            this.last = 0;
        }
        ++this.size;
        if (this.waitingForNewItem > 0) {
            this.notify();
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }
}

