/*
 * Decompiled with CFR 0.152.
 */
package net.gleamynode.netty2;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.gleamynode.netty2.ExceptionMonitor;

public class ExceptionLoggingMonitor
implements ExceptionMonitor {
    private static final ExceptionLoggingMonitor instance = new ExceptionLoggingMonitor();
    private static final Object log;
    private static final Method errorMethod;

    protected ExceptionLoggingMonitor() {
    }

    protected static void logError(String message, Throwable cause) {
        if (log == null) {
            ExceptionLoggingMonitor.logToStderr(message, cause);
        } else {
            try {
                errorMethod.invoke(log, message, cause);
            }
            catch (Exception e) {
                ExceptionLoggingMonitor.logToStderr(message, cause);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logToStderr(String message, Throwable cause) {
        SimpleDateFormat sdf = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss] '[ERROR]' ");
        PrintStream printStream = System.err;
        synchronized (printStream) {
            System.err.print(sdf.format(new Date()));
            System.err.println(message);
            cause.printStackTrace(System.err);
        }
    }

    public static ExceptionLoggingMonitor getInstance() {
        return instance;
    }

    public void exceptionCaught(Throwable exception) {
        ExceptionLoggingMonitor.logError("Unexpected exception.", exception);
    }

    static {
        Object tempLog = null;
        Method tempErrorMethod = null;
        try {
            Class<?> logCls = Class.forName("org.apache.commons.logging.Log");
            Class<?> logFactoryCls = Class.forName("org.apache.commons.logging.LogFactory");
            Method getLogMethod = logFactoryCls.getMethod("getLog", String.class);
            tempLog = getLogMethod.invoke(null, ExceptionLoggingMonitor.class.getPackage().getName());
            tempErrorMethod = logCls.getMethod("error", Object.class, Throwable.class);
        }
        catch (Exception e) {
            tempLog = null;
            tempErrorMethod = null;
        }
        log = tempLog;
        errorMethod = tempErrorMethod;
    }
}

